/*
 * Decompiled with CFR 0.152.
 */
package org.fda.alignmentparser.paf;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import org.fda.alignment.NucmerAlignment;
import org.fda.alignment.ScaffoldContig;
import org.fda.alignmentparser.AlignmentReaderRunnable;
import org.fda.alignmentparser.paf.Cigar;
import org.fda.alignmentparser.paf.CigarElement;
import org.fda.alignmentparser.paf.CigarOperator;
import org.fda.alignmentparser.paf.PafFileReader;
import org.fda.alignmentparser.paf.PafRecord;
import org.fda.basicstats.ContigRecord;
import org.fda.data.Enums;
import org.fda.data.ReferenceSet;
import org.fda.exceptions.IllegalIntervalException;

public class PafReaderRunnable
extends AlignmentReaderRunnable {
    private PafFileReader pfr = new PafFileReader();
    private final File sourceFolder;

    public PafReaderRunnable(BlockingQueue inqueue, BlockingQueue outqueue, ReferenceSet ch, int no, File sourceFolder) {
        super(inqueue, outqueue, ch, no);
        this.sourceFolder = sourceFolder;
    }

    private NucmerAlignment createNucmerAlignment(PafRecord r) throws IllegalIntervalException {
        Cigar cig = r.getCigar();
        ArrayList<Integer> deltas = new ArrayList<Integer>();
        CigarElement cigPrev = null;
        for (CigarElement cigTmp : cig) {
            int k;
            if (cigTmp.getOperator() == CigarOperator.HARD_CLIP || cigTmp.getOperator() == CigarOperator.SOFT_CLIP) continue;
            if (cigTmp.getOperator() == CigarOperator.DELETION) {
                if (cigPrev == null) {
                    deltas.add(1);
                } else if (cigPrev.getOperator() == CigarOperator.MATCH_OR_MISMATCH) {
                    deltas.add(cigPrev.getLength() + 1);
                }
                if (cigTmp.getLength() > 1) {
                    for (k = 0; k < cigTmp.getLength() - 1; ++k) {
                        deltas.add(1);
                    }
                }
            } else if (cigTmp.getOperator() == CigarOperator.INSERTION) {
                if (cigPrev == null) {
                    deltas.add(-1);
                } else if (cigPrev != null && cigPrev.getOperator() == CigarOperator.MATCH_OR_MISMATCH) {
                    deltas.add(-(cigPrev.getLength() + 1));
                }
                if (cigTmp.getLength() > 1) {
                    for (k = 0; k < cigTmp.getLength() - 1; ++k) {
                        deltas.add(-1);
                    }
                }
            }
            cigPrev = cigTmp;
        }
        int[] del = new int[deltas.size()];
        for (int j = 0; j < deltas.size(); ++j) {
            del[j] = (Integer)deltas.get(j);
        }
        int idc = deltas.size();
        int total = Math.abs(r.getRefSt() - r.getRefEnd()) + 1 + idc;
        double id = (double)(total - idc) / (double)total * 100.0;
        int simc = 0;
        int stpc = 0;
        return new NucmerAlignment(r.getReference(), r.getRefSt(), r.getRefEnd(), r.getOrientation() == Enums.Orientation.F ? r.getContSt() : r.getContEnd(), r.getOrientation() == Enums.Orientation.F ? r.getContEnd() : r.getContSt(), idc, simc, stpc, id, 0.0, 0.0, del);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(List<File> filelist) {
        HashSet<String> asc = new HashSet<String>();
        PafFileReader pfr = new PafFileReader();
        HashMap<String, ScaffoldContig> alignmentCollection = new HashMap<String, ScaffoldContig>();
        Map contigs = null;
        ObjectInputStream input = null;
        try {
            input = new ObjectInputStream(new BufferedInputStream(new FileInputStream(new File(this.sourceFolder.getAbsolutePath() + File.separator + "contigRecords.bin"))));
            contigs = (Map)input.readObject();
            for (File f : filelist) {
                PafRecord rec;
                pfr.openFile(f, this.chrset);
                while ((rec = pfr.readNextPafRecord()) != null) {
                    try {
                        asc.add(rec.getContigID());
                        if (alignmentCollection.containsKey(rec.getContigID())) {
                            ((ScaffoldContig)alignmentCollection.get(rec.getContigID())).addAlignment(this.createNucmerAlignment(rec));
                            continue;
                        }
                        ScaffoldContig as = new ScaffoldContig(rec.getContigID(), rec.getContigLength());
                        as.addAlignment(this.createNucmerAlignment(rec));
                        as.setHashValue(((ContigRecord)contigs.get(rec.getContigID())).getHashValue());
                        as.setSeqHashValue(((ContigRecord)contigs.get(rec.getContigID())).getSeqHashValue());
                        as.setGCCount(((ContigRecord)contigs.get(rec.getContigID())).getGCCount());
                        as.setGapIntervalTree(((ContigRecord)contigs.get(rec.getContigID())).getGapIntervals());
                        as.setNCount(((ContigRecord)contigs.get(rec.getContigID())).getNCount());
                        alignmentCollection.put(rec.getContigID(), as);
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                }
                pfr.closeReader();
            }
            for (String contID : asc) {
                this.outqueue.put(alignmentCollection.get(contID));
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException ex) {
            if (!(ex instanceof EOFException)) {
                ex.printStackTrace();
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        catch (IllegalIntervalException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                input.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

