/*
 * Decompiled with CFR 0.152.
 */
package org.fda.alignmentparser.paf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.fda.alignmentparser.paf.CigarElement;
import org.fda.alignmentparser.paf.CigarOperator;
import org.fda.alignmentparser.paf.TextCigarCodec;

public class Cigar
implements Serializable,
Iterable<CigarElement> {
    public static final long serialVersionUID = 1L;
    private final List<CigarElement> cigarElements = new ArrayList<CigarElement>();

    public Cigar() {
    }

    public Cigar(List<CigarElement> cigarElements) {
        this.cigarElements.addAll(cigarElements);
    }

    public List<CigarElement> getCigarElements() {
        return Collections.unmodifiableList(this.cigarElements);
    }

    public CigarElement getCigarElement(int i) {
        return this.cigarElements.get(i);
    }

    public void add(CigarElement cigarElement) {
        this.cigarElements.add(cigarElement);
    }

    public int numCigarElements() {
        return this.cigarElements.size();
    }

    public boolean isEmpty() {
        return this.cigarElements.isEmpty();
    }

    public int getReferenceLength() {
        int length = 0;
        for (CigarElement element : this.cigarElements) {
            switch (element.getOperator()) {
                case M: 
                case D: 
                case N: 
                case EQ: 
                case X: {
                    length += element.getLength();
                    break;
                }
            }
        }
        return length;
    }

    public int getPaddedReferenceLength() {
        int length = 0;
        for (CigarElement element : this.cigarElements) {
            switch (element.getOperator()) {
                case M: 
                case D: 
                case N: 
                case EQ: 
                case X: 
                case P: {
                    length += element.getLength();
                    break;
                }
            }
        }
        return length;
    }

    public int getReadLength() {
        return Cigar.getReadLength(this.cigarElements);
    }

    public static int getReadLength(List<CigarElement> cigarElements) {
        int length = 0;
        for (CigarElement element : cigarElements) {
            if (!element.getOperator().consumesReadBases()) continue;
            length += element.getLength();
        }
        return length;
    }

    private static boolean isRealOperator(CigarOperator op) {
        return op == CigarOperator.M || op == CigarOperator.EQ || op == CigarOperator.X || op == CigarOperator.I || op == CigarOperator.D || op == CigarOperator.N;
    }

    private static boolean isInDelOperator(CigarOperator op) {
        return op != null && op.isIndel();
    }

    private static boolean isClippingOperator(CigarOperator op) {
        return op != null && op.isClipping();
    }

    private static boolean isPaddingOperator(CigarOperator op) {
        return op != null && op.isPadding();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Cigar)) {
            return false;
        }
        Cigar cigar = (Cigar)o;
        return this.cigarElements.equals(cigar.cigarElements);
    }

    public static Cigar fromCigarOperators(List<CigarOperator> cigarOperators) {
        if (cigarOperators == null) {
            throw new IllegalArgumentException("cigarOperators is null");
        }
        ArrayList<CigarElement> cigarElementList = new ArrayList<CigarElement>();
        int i = 0;
        while (i < cigarOperators.size()) {
            int j;
            CigarOperator currentOp = cigarOperators.get(i);
            for (j = i + 1; j < cigarOperators.size() && cigarOperators.get(j).equals((Object)currentOp); ++j) {
            }
            cigarElementList.add(new CigarElement(j - i, currentOp));
            i = j;
        }
        return new Cigar(cigarElementList);
    }

    @Override
    public Iterator<CigarElement> iterator() {
        return this.getCigarElements().iterator();
    }

    public boolean containsOperator(CigarOperator operator) {
        return this.cigarElements.stream().anyMatch(element -> element.getOperator() == operator);
    }

    public CigarElement getFirstCigarElement() {
        return this.isEmpty() ? null : this.cigarElements.get(0);
    }

    public CigarElement getLastCigarElement() {
        return this.isEmpty() ? null : this.cigarElements.get(this.numCigarElements() - 1);
    }

    public boolean isLeftClipped() {
        return !this.isEmpty() && Cigar.isClippingOperator(this.getFirstCigarElement().getOperator());
    }

    public boolean isRightClipped() {
        return !this.isEmpty() && Cigar.isClippingOperator(this.getLastCigarElement().getOperator());
    }

    public boolean isClipped() {
        return this.isLeftClipped() || this.isRightClipped();
    }

    public int hashCode() {
        return this.cigarElements.hashCode();
    }

    public String toString() {
        return TextCigarCodec.encode(this);
    }
}

