/*
 * Decompiled with CFR 0.152.
 */
package org.fda.alignmentparser.delta;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.fda.alignmentparser.delta.DeltaRecord;
import org.fda.data.Reference;
import org.fda.data.ReferenceSet;
import org.fda.data.Utilities;

public class DeltaFileReader {
    private BufferedReader br;
    private String header = null;
    private ReferenceSet chrset;

    public void openFile(File f, ReferenceSet c) throws FileNotFoundException, IOException {
        this.chrset = c;
        this.br = new BufferedReader(new FileReader(f));
        for (int i = 0; i < 2; ++i) {
            this.header = this.header + Utilities.ls + this.br.readLine();
        }
    }

    public DeltaRecord readNextDeltaRecord() {
        String contigID = null;
        Reference refID = null;
        DeltaRecord dr = null;
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        int contigLength = 0;
        int refChrLength = 0;
        try {
            String line;
            while ((line = this.br.readLine()) != null) {
                if (line.startsWith(">")) {
                    if (first) {
                        line = line.substring(1);
                        String[] rec = line.split(" ");
                        contigID = rec[1];
                        refID = this.chrset.findReference(rec[0]);
                        contigLength = Integer.parseInt(rec[3]);
                        refChrLength = Integer.parseInt(rec[2]);
                        first = false;
                        continue;
                    }
                    this.br.reset();
                    break;
                }
                sb = sb.append(line + Utilities.ls);
                this.br.mark(50000);
            }
            if (contigID != null && refID != null) {
                dr = new DeltaRecord(refID, contigID, sb.toString(), contigLength, refChrLength);
            } else {
                this.br.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dr;
    }

    public void closeReader() throws FileNotFoundException, IOException {
        this.br.close();
    }
}

