/*
 * Decompiled with CFR 0.152.
 */
package org.fda.alignment;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.fda.alignment.Alignment;
import org.fda.data.Enums;
import org.fda.data.Misassembly;
import org.fda.data.Reference;
import org.fda.data.Utilities;
import org.fda.intervaltree.Interval;
import org.fda.intervaltree.IntervalSearchTree;

public class ScaffoldContig
implements Comparable<ScaffoldContig>,
Serializable {
    private static final long serialVersionUID = 211241001102182489L;
    private Map<Enums.Inconsistency, List<Misassembly>> missassemblyMap;
    private Map<Reference, List<Alignment>> refAlignmentMap = new HashMap<Reference, List<Alignment>>();
    private final String id;
    private final int contigSize;
    private int nongapcontigSize;
    private IntervalSearchTree gapIntervalTree;
    private int ncount;
    private int gccount;
    private double nratio;
    private double gcratio;
    private int alignableSizeOnContig = 0;
    private int coveredSizeOnReference = 0;
    private double contigSizeAligPerc = 0.0;
    private Enums.CoverageType coverageType = Enums.CoverageType.NONE;
    private double quality = 0.0;
    private Reference mostlyAlignedRef = null;
    private byte[] hashValue = null;
    private byte[] seqHashValue = null;
    private boolean isMisassambled = false;
    private int totalNumberofIncons = 0;
    private boolean containsScaffoldingGap = false;

    public ScaffoldContig(String contigID, int contigSize, int ncount, int gccount, IntervalSearchTree ist) {
        this(contigID, contigSize);
        this.setGCCount(gccount);
        this.setNCount(ncount);
        this.gapIntervalTree = ist;
    }

    public ScaffoldContig(String contigID, int contigSize) {
        this.id = contigID;
        this.contigSize = contigSize;
        this.nongapcontigSize = contigSize;
        this.init();
    }

    public boolean containsScaffoldingGap() {
        return this.containsScaffoldingGap;
    }

    public void setGapIntervalTree(IntervalSearchTree ist) {
        this.gapIntervalTree = ist;
    }

    public IntervalSearchTree getGapIntervalTree() {
        return this.gapIntervalTree;
    }

    public byte[] getSeqHashValue() {
        return this.seqHashValue;
    }

    public void setSeqHashValue(byte[] seqHashValue) {
        this.seqHashValue = seqHashValue;
    }

    public byte[] getHashValue() {
        return this.hashValue;
    }

    public void setHashValue(byte[] hashValue) {
        this.hashValue = hashValue;
    }

    public Map<Enums.Inconsistency, List<Misassembly>> getMisassemblyMap() {
        return this.missassemblyMap;
    }

    public Map<Reference, List<Alignment>> getRefAlignmentMap() {
        return this.refAlignmentMap;
    }

    public int getNcount() {
        return this.ncount;
    }

    public int getGccount() {
        return this.gccount;
    }

    public double getGcratio() {
        return this.gcratio;
    }

    public double getContigSizeAligPerc() {
        return this.contigSizeAligPerc;
    }

    public Reference getMostlyAlignedRef() {
        return this.mostlyAlignedRef;
    }

    public void setNCount(int n) {
        this.ncount = n;
        this.nratio = (double)this.ncount / (double)this.contigSize;
    }

    public void setGCCount(int gc) {
        this.gccount = gc;
        this.gcratio = (double)this.gccount / (double)this.contigSize;
    }

    public int getGCCount() {
        return this.gccount;
    }

    public double getNRatio() {
        return this.nratio;
    }

    public double getGCRatio() {
        return this.gcratio;
    }

    public int getTotalInconsistencyNumber() {
        return this.totalNumberofIncons;
    }

    public void setMisassembly() {
        this.init();
        List<Alignment> a2ret = this.getAlignments();
        for (int i = 0; i < a2ret.size() - 1; ++i) {
            Alignment a = a2ret.get(i);
            Alignment b = a2ret.get(i + 1);
            if (a.getReference().equals(b.getReference())) {
                if (a.getReferenceInterval().overlap(b.getReferenceInterval()) >= Utilities.alignmentDistanceThreshold) {
                    this.addInconsistency(new Misassembly(Enums.Inconsistency.RELOCATION, a, b));
                    continue;
                }
                if (a.getReferenceInterval().getDistance(b.getReferenceInterval()) >= Utilities.alignmentDistanceThreshold) {
                    Interval refgapinterval = Interval.getIntervalBetween(a.getReferenceInterval(), b.getReferenceInterval());
                    Interval contiggapinterval = Interval.getIntervalBetween(a.getContigInterval(), b.getContigInterval());
                    if (contiggapinterval != null) {
                        Reference r = a.getReference();
                        List<Interval> ref_intersections = r.getGapIntervalTree().searchAll(refgapinterval);
                        List<Interval> contig_intersections = this.getGapIntervalTree().searchAll(contiggapinterval);
                        if (!ref_intersections.isEmpty() && !contig_intersections.isEmpty() && Interval.MaxRO(refgapinterval, ref_intersections) >= Utilities.scaffoldinggapoverlapratio && Interval.MaxRO(contiggapinterval, contig_intersections) >= Utilities.scaffoldinggapoverlapratio) {
                            this.addInconsistency(new Misassembly(Enums.Inconsistency.SCAFFOLD_GAP, a, b));
                            continue;
                        }
                    }
                    this.addInconsistency(new Misassembly(Enums.Inconsistency.RELOCATION, a, b));
                    continue;
                }
                if (a.getContigOrientation() == b.getContigOrientation()) continue;
                this.addInconsistency(new Misassembly(Enums.Inconsistency.INVERSION, a, b));
                continue;
            }
            this.addInconsistency(new Misassembly(Enums.Inconsistency.TRANSLOCATION, a, b));
        }
    }

    public boolean getIsMisassembled() {
        return this.isMisassambled;
    }

    public double getContigAlignPerc() {
        return this.contigSizeAligPerc;
    }

    public int getCoveredSizeOnReference() {
        return this.coveredSizeOnReference;
    }

    public int getAlignableSizeOnContig() {
        return this.alignableSizeOnContig;
    }

    public Enums.CoverageType getCoverageType() {
        return this.coverageType;
    }

    public void checkAlignmentsForGaps() {
        List<Alignment> a2ret = this.getAlignments();
        for (int i = 0; i < a2ret.size() - 1; ++i) {
            double sizeratio;
            Alignment a = a2ret.get(i);
            Alignment b = a2ret.get(i + 1);
            if (!a.getReference().equals(b.getReference())) continue;
            Interval refgapinterval = Interval.getIntervalBetween(a.getReferenceInterval(), b.getReferenceInterval());
            Interval contiggapinterval = Interval.getIntervalBetween(a.getContigInterval(), b.getContigInterval());
            Reference r = a.getReference();
            if (refgapinterval == null || contiggapinterval == null) continue;
            List<Interval> ref_intersections = r.getGapIntervalTree().searchAll(refgapinterval);
            List<Interval> contig_intersections = this.getGapIntervalTree().searchAll(contiggapinterval);
            if (ref_intersections.isEmpty() || contig_intersections.isEmpty() || !(Interval.MaxRO(refgapinterval, ref_intersections) >= Utilities.scaffoldinggapoverlapratio) || !(Interval.MaxRO(contiggapinterval, contig_intersections) >= Utilities.scaffoldinggapoverlapratio) || !((sizeratio = (double)refgapinterval.getlength() / (double)contiggapinterval.getlength()) >= 1.0 - Utilities.sizeratiodifference) || !(sizeratio <= 1.0 + Utilities.sizeratiodifference)) continue;
            this.nongapcontigSize -= contiggapinterval.getlength();
        }
    }

    public void setCoverage(int asoc, int csor) {
        this.alignableSizeOnContig = asoc;
        this.coveredSizeOnReference = csor;
        this.checkAlignmentsForGaps();
        this.contigSizeAligPerc = 100.0 * (double)this.alignableSizeOnContig / (double)this.nongapcontigSize;
        this.coverageType = this.contigSizeAligPerc == 100.0 ? Enums.CoverageType.FULL : Enums.CoverageType.PARTIAL;
    }

    public String getId() {
        return this.id;
    }

    public List<Alignment> getAlignments() {
        ArrayList<Alignment> toRet = new ArrayList<Alignment>();
        for (List<Alignment> tmp : this.refAlignmentMap.values()) {
            toRet.addAll(tmp);
        }
        Collections.sort(toRet, new Comparator<Alignment>(){

            @Override
            public int compare(Alignment o1, Alignment o2) {
                return o1.getContSt() - o2.getContSt();
            }
        });
        return toRet;
    }

    public List<Alignment> getAlignments(Reference c) {
        return this.refAlignmentMap.get(c);
    }

    private int getSum(List<Alignment> lst) {
        int sum = 0;
        for (Alignment l : lst) {
            sum += l.getRefAlignmentLength();
        }
        return sum;
    }

    private void setMostFavouredReference() {
        Reference mx = null;
        int max = 0;
        for (Reference r : this.refAlignmentMap.keySet()) {
            if (mx == null) {
                mx = r;
                max = this.getSum(this.refAlignmentMap.get(r));
                continue;
            }
            int tmp = this.getSum(this.refAlignmentMap.get(r));
            if (tmp <= max) continue;
            mx = r;
            max = tmp;
        }
        this.mostlyAlignedRef = mx;
    }

    public void setAlignments(List<Alignment> alignments) {
        this.refAlignmentMap = new HashMap<Reference, List<Alignment>>();
        for (Alignment a : alignments) {
            this.addAlignment(a);
        }
        this.setMostFavouredReference();
    }

    public Set<Reference> getReferences() {
        return this.refAlignmentMap.keySet();
    }

    public int getContigLength() {
        return this.contigSize;
    }

    private void init() {
        this.totalNumberofIncons = 0;
        this.missassemblyMap = new TreeMap<Enums.Inconsistency, List<Misassembly>>();
        for (Enums.Inconsistency i : Enums.Inconsistency.values()) {
            this.missassemblyMap.put(i, new ArrayList());
        }
    }

    public void addInconsistency(Misassembly m) {
        if (m.getType() != Enums.Inconsistency.SCAFFOLD_GAP) {
            ++this.totalNumberofIncons;
            this.isMisassambled = true;
        }
        this.missassemblyMap.get(m.getType()).add(m);
        this.containsScaffoldingGap = true;
    }

    public int getInconsistencyCount(Enums.Inconsistency i) {
        return this.missassemblyMap.get(i).size();
    }

    public void assignQuality() {
        double alignmentRatio = this.contigSizeAligPerc / 100.0;
        if (alignmentRatio == 0.0) {
            this.quality = 0.0;
        } else {
            this.setMisassembly();
            this.quality = Utilities.getLengthScalingCoefficient(this.contigSize) * Utilities.alpha * alignmentRatio / (1.0 + Utilities.beta * Utilities.getPenalty(this.contigSize, this.totalNumberofIncons, this.mostlyAlignedRef));
        }
    }

    public void setQuality(double c) {
        this.quality = c;
    }

    public double getQuality() {
        return this.quality;
    }

    public void addAlignments(List<Alignment> aList) {
        for (Alignment a : aList) {
            this.addAlignment(a);
        }
    }

    public void addAlignment(Alignment a) {
        if (this.refAlignmentMap.containsKey(a.getReference())) {
            this.refAlignmentMap.get(a.getReference()).add(a);
        } else {
            ArrayList<Alignment> tmp = new ArrayList<Alignment>();
            tmp.add(a);
            this.refAlignmentMap.put(a.getReference(), tmp);
        }
    }

    public double value() {
        double sum = 0.0;
        for (Alignment a : this.getAlignments()) {
            sum += a.getIdentity() * (double)a.getRefAlignmentLength();
        }
        return sum;
    }

    @Override
    public int compareTo(ScaffoldContig o) {
        double value2;
        double value1 = this.value();
        if (value1 > (value2 = o.value())) {
            return 1;
        }
        if (value1 < value2) {
            return -1;
        }
        return 0;
    }

    public String toString(boolean detailed) {
        NumberFormat nr = Utilities.numberFormatter;
        StringBuilder sb = new StringBuilder();
        List<Alignment> alignments = this.getAlignments();
        if (detailed) {
            for (Alignment a : alignments) {
                sb.append(this.id + a + Utilities.ls);
            }
        } else {
            sb.append(this.id + "\t" + nr.format(this.contigSize) + "\t" + nr.format(this.alignableSizeOnContig) + "\t" + nr.format(this.contigSizeAligPerc) + "\t" + nr.format(this.getGCRatio()) + "\t" + nr.format(this.getNRatio()) + "\t" + nr.format(this.getQuality()));
            for (Enums.Inconsistency i : Enums.Inconsistency.values()) {
                sb.append("\t" + this.getInconsistencyCount(i));
            }
            sb.append("\t" + this.totalNumberofIncons);
            sb.append(Utilities.ls);
        }
        return sb.toString();
    }

    public String getString4Misassemblies() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Enums.Inconsistency, List<Misassembly>> ent : this.getMisassemblyMap().entrySet()) {
            if (ent.getValue().size() == 0) continue;
            for (Misassembly m : ent.getValue()) {
                sb.append(this.getId() + "\t");
                sb.append(m + Utilities.ls);
            }
        }
        return sb.toString();
    }
}

