/*
 * Decompiled with CFR 0.152.
 */
package org.fda.regression;

import java.io.Serializable;
import java.util.List;
import org.fda.data.Utilities;
import org.fda.regression.DataValue;

public class RegressionSubModel
implements Serializable {
    private static final long serialVersionUID = -3261334363750582918L;
    private double intercept;
    private double thresholdCoeff;
    private double lengthCoeff;
    private List<DataValue> dvList;

    public RegressionSubModel(double lengthCoeff, double thresholdCoeff, double intercept, List<DataValue> dvList) {
        this.intercept = intercept;
        this.lengthCoeff = lengthCoeff;
        this.thresholdCoeff = thresholdCoeff;
        this.dvList = dvList;
    }

    public void setIntercept(double intercept) {
        this.intercept = intercept;
    }

    public void setThresholdCoeff(double thresholdCoeff) {
        this.thresholdCoeff = thresholdCoeff;
    }

    public void setLengthCoeff(double lengthCoeff) {
        this.lengthCoeff = lengthCoeff;
    }

    public double getIntercept() {
        return this.intercept;
    }

    public double getThresholdCoeff() {
        return this.thresholdCoeff;
    }

    public double getLengthCoeff() {
        return this.lengthCoeff;
    }

    public double calculateValue(double length, double thre) {
        return length * this.lengthCoeff + thre * this.thresholdCoeff + this.intercept;
    }

    public String toString() {
        String r = Utilities.numberFormatterSmall.format(this.getLengthCoeff()) + "\t" + Utilities.numberFormatterSmall.format(this.getThresholdCoeff()) + "\t" + Utilities.numberFormatterSmall.format(this.getIntercept()) + Utilities.ls;
        return r;
    }

    public String inTabDelimFormat() {
        String r = "\tLength coefficient: " + this.getLengthCoeff() + Utilities.ls + "\tThreshold Coefficient: " + this.getThresholdCoeff() + Utilities.ls + "\tIntercept: " + this.getIntercept() + Utilities.ls;
        return r;
    }
}

