/*
 * Decompiled with CFR 0.152.
 */
package org.fda.multithreading;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.fda.alignment.ScaffoldContig;
import org.fda.basicstats.ContigRecord;
import org.fda.data.Enums;
import org.fda.data.Utilities;
import org.fda.evaluator.Processor;

public class StandaloneContigAlignmentQueueMonitor
implements Runnable {
    private BlockingQueue queue;
    private ObjectOutputStream out = null;
    private BufferedWriter bw;
    private BufferedWriter bwc;
    private int contigCount = 0;
    private File sourceFolder;
    private Processor p;

    public int getContigCount() {
        return this.contigCount;
    }

    public StandaloneContigAlignmentQueueMonitor(BlockingQueue queue, File contigbinfile, File outputfile, File sourceFolder, Processor p) {
        this.queue = queue;
        this.sourceFolder = sourceFolder;
        this.p = p;
        this.bwc = null;
        try {
            this.out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(contigbinfile)));
            this.bw = new BufferedWriter(new FileWriter(outputfile));
            this.bw.append("Contig ID\tContig Size\tAligned Contig Size\tAlignment Percentage\tGC Ratio\tAmbiguous Base (N) Ratio\tQuality Score");
            for (Enums.Inconsistency nci : Enums.Inconsistency.values()) {
                this.bw.append("\t" + nci);
            }
            this.bw.append(Utilities.ls);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    public StandaloneContigAlignmentQueueMonitor(BlockingQueue queue, File contigbinfile, BufferedWriter bw, File sourceFolder, BufferedWriter bwc, Processor p) {
        this.queue = queue;
        this.sourceFolder = sourceFolder;
        this.bw = bw;
        this.bwc = bwc;
        this.p = p;
        try {
            this.out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(contigbinfile)));
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ObjectInputStream input = null;
        Map contigs = null;
        try {
            input = new ObjectInputStream(new BufferedInputStream(new FileInputStream(new File(this.sourceFolder.getAbsolutePath() + File.separator + "contigRecords.bin"))));
            contigs = (Map)input.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            try {
                input.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        while (true) {
            try {
                Object o;
                while (!((o = this.queue.take()) instanceof Enums.STOPOBJECT)) {
                    if (!(o instanceof ScaffoldContig)) continue;
                    String id = ((ScaffoldContig)o).getId();
                    if (contigs.containsKey(id)) {
                        contigs.remove(id);
                    }
                    this.out.writeObject(o);
                    this.p.process((ScaffoldContig)o);
                    this.bw.append(((ScaffoldContig)o).toString(false));
                    this.bwc.append(((ScaffoldContig)o).toString(true));
                    ++this.contigCount;
                }
            }
            catch (Exception io) {
                io.printStackTrace();
                continue;
            }
            break;
        }
        try {
            for (Map.Entry ent : contigs.entrySet()) {
                ContigRecord cr = (ContigRecord)ent.getValue();
                ScaffoldContig as = new ScaffoldContig(cr.getContigName(), cr.getLength(), cr.getNCount(), cr.getGCCount(), cr.getGapIntervals());
                as.setHashValue(cr.getHashValue());
                as.setSeqHashValue(cr.getSeqHashValue());
                this.bw.append(as.toString(false));
                this.bwc.append(as.toString(true));
                this.out.writeObject(as);
                ++this.contigCount;
            }
            this.out.close();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }
}

