/*
 * Decompiled with CFR 0.152.
 */
package org.fda.multithreading;

import java.io.File;
import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import org.fda.data.Enums;
import org.fda.data.Utilities;
import org.fda.multithreading.ScriptRunner;

public class ScriptHelper {
    File[] fArr;

    public ScriptHelper(File[] fA) {
        this.fArr = fA;
        for (int k = 0; k < this.fArr.length; ++k) {
            this.fArr[k].setExecutable(true);
        }
    }

    public ScriptHelper(Collection<File> fA) {
        this.fArr = fA.toArray(new File[0]);
        for (int k = 0; k < this.fArr.length; ++k) {
            this.fArr[k].setExecutable(true);
        }
    }

    public void run() {
        try {
            if (Utilities.submitJobs == Enums.ScriptRunMode.qsub || Utilities.submitJobs == Enums.ScriptRunMode.sbatch) {
                Runtime r = Runtime.getRuntime();
                for (int k = 0; k < this.fArr.length; ++k) {
                    String qsub_cmd = (Object)((Object)Utilities.submitJobs) + " " + Utilities.submitJobsParameters + " " + this.fArr[k].getAbsolutePath();
                    System.out.println(qsub_cmd);
                    Process p = r.exec(qsub_cmd);
                    p.waitFor();
                }
            } else {
                int i;
                ArrayBlockingQueue<Object> q = new ArrayBlockingQueue<Object>(this.fArr.length + Utilities.no_threads);
                for (int k = 0; k < this.fArr.length; ++k) {
                    q.put(this.fArr[k].getAbsolutePath());
                }
                for (int i2 = 0; i2 < Utilities.no_threads; ++i2) {
                    q.put((Object)Enums.STOPOBJECT.STOP);
                }
                Thread[] scriptThread = new Thread[Utilities.no_threads];
                for (i = 0; i < Utilities.no_threads; ++i) {
                    scriptThread[i] = new Thread(new ScriptRunner(q));
                    scriptThread[i].start();
                }
                for (i = 0; i < scriptThread.length; ++i) {
                    scriptThread[i].join();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

