/*
 * Decompiled with CFR 0.152.
 */
package org.fda.intervaltree;

import java.util.ArrayList;
import java.util.List;
import org.fda.exceptions.IllegalIntervalException;
import org.fda.intervaltree.Interval;
import org.fda.intervaltree.IntervalSearchTree;

public class MergedIntervalSearchTree
extends IntervalSearchTree {
    private static final long serialVersionUID = 112414357102382689L;
    private long totalSize = 0L;

    public long getTotalSize() {
        return this.totalSize;
    }

    public synchronized boolean put(Interval interval, boolean generateSubs) {
        ArrayList<Interval> ist = new ArrayList<Interval>();
        interval.incrementCount();
        if (!this.contains(interval, ist)) {
            List<Interval> intersectingIntervals = this.searchAll(interval);
            this.mergeIntervals(intersectingIntervals, interval, generateSubs);
            return true;
        }
        ((Interval)ist.get(0)).incrementCount();
        return false;
    }

    private void mergeIntervals(List<Interval> intersectingIntervals, Interval newInterval, boolean generateSubs) {
        if (!intersectingIntervals.isEmpty()) {
            int smallestStCoord = newInterval.getlow();
            int largestEndCoord = newInterval.gethigh();
            for (Interval it : intersectingIntervals) {
                if (it.getlow() < smallestStCoord) {
                    smallestStCoord = it.getlow();
                }
                if (it.gethigh() > largestEndCoord) {
                    largestEndCoord = it.gethigh();
                }
                this.remove(it);
                this.totalSize -= (long)it.getlength();
            }
            try {
                Interval id2Insert;
                boolean safeToadd = true;
                if (!generateSubs) {
                    id2Insert = new Interval(smallestStCoord, largestEndCoord, intersectingIntervals.size() > 0);
                } else {
                    id2Insert = new Interval(smallestStCoord, largestEndCoord, intersectingIntervals.size() > 0);
                    for (Interval it : intersectingIntervals) {
                        if (it.getMerged()) {
                            for (Interval it2 : it.getsubIntervals()) {
                                if (it2.compareTo(newInterval) == 0) {
                                    it2.incrementCount();
                                    safeToadd = false;
                                }
                                id2Insert.add2SubIntervals(it2);
                            }
                            continue;
                        }
                        id2Insert.add2SubIntervals(it);
                    }
                    if (safeToadd) {
                        id2Insert.add2SubIntervals(newInterval);
                    }
                }
                this.totalSize += (long)id2Insert.getlength();
                this.putWOCheck4DuplicateEntry(id2Insert, generateSubs);
            }
            catch (IllegalIntervalException e) {
                e.printStackTrace();
                System.out.println("Illegal subintervals");
                System.exit(1);
            }
        } else {
            this.totalSize += (long)newInterval.getlength();
            this.putWOCheck4DuplicateEntry(newInterval, generateSubs);
        }
    }

    protected void putWOCheck4DuplicateEntry(Interval interval, boolean generateSubs) {
        this.root = this.randomizedInsert(this.root, interval);
    }

    public static void main(String[] args) {
        MergedIntervalSearchTree mst = new MergedIntervalSearchTree();
        try {
            mst.put(new Interval(1, 10, false), true);
            mst.put(new Interval(2, 11, false), true);
            mst.put(new Interval(1, 10, false), true);
            mst.put(new Interval(11, 12, false), true);
            mst.put(new Interval(1, 12, false), true);
            mst.put(new Interval(1, 12, false), true);
            mst.put(new Interval(15, 18, false), true);
            mst.put(new Interval(15, 16, false), true);
            mst.put(new Interval(15, 16, false), true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<Interval> i = mst.inOrder();
        for (Interval v : i) {
            System.out.println(v.toStringWSubIntervals());
        }
        System.out.println(mst.getTotalSize());
    }
}

