/*
 * Decompiled with CFR 0.152.
 */
package org.fda.inputdataparser;

import org.fda.data.Utilities;
import org.fda.inputdataparser.ReadRecord;

public class FastqRecord
extends ReadRecord {
    protected String qstr;

    public FastqRecord(String header, String read, String qstr, int gc_count) {
        this.header = header;
        this.read = read;
        this.qstr = qstr;
        this.name = header.split("\\s+")[0].substring(1);
        this.gc_count = gc_count;
        this.gc_percent = Utilities.calcPercentage(gc_count, read.length());
    }

    public String getQualityStr() {
        return this.qstr;
    }

    @Override
    public String toString() {
        return "@" + this.name + Utilities.ls + this.read + Utilities.ls + "+" + Utilities.ls + this.qstr;
    }

    public String getInFasta() {
        return ">" + this.name + Utilities.ls + this.read;
    }
}

