/*
 * Decompiled with CFR 0.152.
 */
package org.fda.inputdataparser;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import org.fda.data.Utilities;
import org.fda.inputdataparser.FastaRecord;
import org.fda.inputdataparser.ReadRecord;

public class FastaWriter
implements Serializable {
    private transient BufferedWriter bw;
    private File fastafile;
    private long readrecordnumber = 0L;
    private long size = 0L;
    private static final long serialVersionUID = 10211435718127689L;

    public long getReadRecordNumber() {
        return this.readrecordnumber;
    }

    public long getSize() {
        return this.size;
    }

    public FastaWriter(File f) {
        this.fastafile = f;
        try {
            this.bw = new BufferedWriter(new FileWriter(this.fastafile));
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public FastaWriter(String fname) {
        this.fastafile = new File(fname);
        try {
            this.bw = new BufferedWriter(new FileWriter(this.fastafile));
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public FastaWriter(File f, boolean append) {
        this.fastafile = f;
        try {
            this.bw = new BufferedWriter(new FileWriter(this.fastafile, append));
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public FastaWriter(String fname, boolean append) {
        this.fastafile = new File(fname);
        try {
            this.bw = new BufferedWriter(new FileWriter(this.fastafile, append));
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public File getFile() {
        return this.fastafile;
    }

    public void closeWriter() {
        try {
            this.bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void write(ReadRecord r) {
        try {
            String wholeread = ((FastaRecord)r).formatRead(50);
            if (!wholeread.startsWith(">")) {
                wholeread = ">" + wholeread;
            }
            this.bw.append(wholeread + Utilities.ls);
            this.size += (long)r.getReadRecordLength();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

