/*
 * Decompiled with CFR 0.152.
 */
package org.fda.inputdataparser;

import org.fda.data.Utilities;
import org.fda.exceptions.IllegalIntervalException;
import org.fda.inputdataparser.ReadRecord;
import org.fda.intervaltree.Interval;
import org.fda.intervaltree.IntervalSearchTree;

public class FastaRecord
extends ReadRecord {
    private IntervalSearchTree nIntervalsTree = null;
    private byte[] hashValue;
    private byte[] seqHashValue;

    public byte[] getHashValue() {
        return this.hashValue;
    }

    public byte[] getSeqHashValue() {
        return this.seqHashValue;
    }

    public IntervalSearchTree getnIntervalsTree() {
        return this.nIntervalsTree;
    }

    public FastaRecord(String header, String read, int gc_count) {
        this.header = header;
        this.read = read;
        this.name = header.split("\\s+")[0].substring(1);
        this.gc_count = gc_count;
        this.gc_percent = Utilities.calcPercentage(gc_count, read.length());
    }

    public FastaRecord(String header, String read, int gc_count, byte[] hashValue) {
        this(header, read, gc_count);
        this.hashValue = hashValue;
    }

    public FastaRecord(String header, String read) {
        this.header = header;
        this.read = read;
        this.nIntervalsTree = new IntervalSearchTree();
        this.name = header.split("\\s+")[0].substring(1);
        boolean insideN = false;
        int stN = 0;
        for (int i = 0; i < read.length(); ++i) {
            if (read.charAt(i) == 'N' || read.charAt(i) == 'n') {
                ++this.ncount;
                if (!insideN) {
                    stN = i + 1;
                }
                insideN = true;
                continue;
            }
            if (insideN) {
                try {
                    insideN = false;
                    int endN = i;
                    this.nIntervalsTree.put(new Interval(stN, endN, false));
                }
                catch (IllegalIntervalException ex) {
                    ex.printStackTrace();
                }
            }
            if (read.charAt(i) != 'G' && read.charAt(i) != 'g' && read.charAt(i) != 'C' && read.charAt(i) != 'c') continue;
            ++this.gc_count;
        }
        if (insideN) {
            try {
                this.nIntervalsTree.put(new Interval(stN, read.length(), false));
            }
            catch (IllegalIntervalException ex) {
                ex.printStackTrace();
            }
        }
        this.nratio = (double)this.ncount / (double)this.getReadRecordLength();
        this.gc_percent = Utilities.calcPercentage(this.gc_count, read.length());
    }

    public FastaRecord(String header, String read, byte[] hashValue) {
        this(header, read);
        this.hashValue = hashValue;
    }

    public FastaRecord(String header, String read, byte[] hashValue, byte[] seqHashValue) {
        this(header, read, hashValue);
        this.seqHashValue = seqHashValue;
    }

    public String formatRead(int linelength) {
        if (linelength <= 0) {
            return this.name + Utilities.ls + this.read;
        }
        StringBuilder sb = new StringBuilder(this.name + Utilities.ls);
        int rep = this.getReadRecordLength() / linelength;
        int st = 0;
        int end = 0;
        for (int i = 0; i < rep; ++i) {
            end = st + linelength;
            sb.append(this.read.substring(st, end) + Utilities.ls);
            st = end;
        }
        if (st < this.getReadRecordLength()) {
            sb.append(this.read.substring(st));
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.formatRead(-1);
    }
}

