/*
 * Decompiled with CFR 0.152.
 */
package org.fda.graphdrawing.chart;

import com.itextpdf.text.Document;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.fda.graphdrawing.ImageFormat;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLabelLocation;
import org.jfree.chart.title.TextTitle;
import org.jfree.ui.RectangleEdge;

public abstract class TwoDPlot {
    protected File file;
    protected ImageFormat fileFormat = null;
    protected int width = 1200;
    protected int height = 800;
    protected String chartName = "TmpPlot";
    protected String xAxisName = "X Axis";
    protected String yAxisName = "Y Axis";
    protected String yAxisNumFormat = null;
    protected String xAxisNumFormat = null;
    protected Font chartNameFont = new Font("Arial", 1, 35);
    protected Font xAxisNameFont = new Font("Arial", 1, 20);
    protected Font yAxisNameFont = new Font("Arial", 1, 20);
    protected Font legendNameFont = new Font("Arial", 0, 20);
    protected Font xAxisTickMarkFont = new Font("Arial", 0, 15);
    protected Font yAxisTickMarkFont = new Font("Arial", 0, 15);
    protected double xAxisTickUnit;
    protected double yAxisTickUnit;
    protected double upperMargin = 0.45;
    protected double lowerMargin = 0.4;
    protected double leftMargin = 0.01;
    protected double rightMargin = 0.01;
    protected double xAxisUpperBound;
    protected double xAxisLowerBound;
    protected double yAxisUpperBound;
    protected double yAxisLowerBound;
    protected Color plotBackgroundPaintColor = Color.WHITE;
    protected Color chartBackgroundPaintColor = Color.WHITE;
    protected Color verticalGridlineColor = Color.GRAY;
    protected Color horizontalGridlineColor = Color.GRAY;
    protected Color xAxisColor = Color.BLACK;
    protected Color xAxisTickLabelColor = Color.BLACK;
    protected Color yAxisColor = Color.BLACK;
    protected Color yAxisTickLabelColor = Color.BLACK;
    protected Color chartOutlineColor = Color.BLACK;
    protected Color plotOutlineColor = Color.BLACK;
    protected boolean chartNameIsVisible = true;
    protected boolean legendIsVisible = true;
    protected boolean legendFrameIsVisible = true;
    protected boolean chartOutlineIsVisible = false;
    protected boolean plotOutlineIsVisible = false;
    protected boolean horizontalGridlineIsVisible = false;
    protected boolean verticalGridlineIsVisible = false;
    protected boolean yAxisIsVisible = true;
    protected boolean xAxisIsVisible = true;
    protected boolean xAxisTickLabelIsVisible = true;
    protected boolean yAxisTickLabelIsVisible = true;
    protected boolean defaultColors = false;
    protected boolean defaultShapes = true;
    protected RectangleEdge legendLocation = RectangleEdge.TOP;
    protected AxisLabelLocation xAxisLabelLocation = AxisLabelLocation.MIDDLE;
    protected AxisLabelLocation yAxisLabelLocation = AxisLabelLocation.MIDDLE;
    protected List<TextTitle> legendText = new ArrayList<TextTitle>();

    public void addLegendText(TextTitle t) {
        this.legendText.add(t);
    }

    protected boolean setFormat() {
        for (ImageFormat format : ImageFormat.values()) {
            if (!this.file.getName().endsWith(format.getExtension())) continue;
            this.fileFormat = format;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveAsFile(JFreeChart chart) {
        FileOutputStream out = null;
        try {
            if (this.file.getParentFile() != null && !this.file.getParentFile().exists()) {
                this.file.getParentFile().mkdirs();
            }
            out = new FileOutputStream(this.file);
            if (this.fileFormat == ImageFormat.png) {
                ChartUtilities.writeChartAsPNG(out, chart, this.width, this.height);
            } else if (this.fileFormat == ImageFormat.jpeg) {
                ChartUtilities.writeChartAsJPEG(out, chart, this.width, this.height);
            } else if (this.fileFormat == ImageFormat.pdf) {
                this.writeChartAsPDF(out, chart, this.width, this.height);
            }
            out.flush();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeChartAsPDF(FileOutputStream output, JFreeChart chart, int width, int height) throws IOException {
        Rectangle pagesize = new Rectangle(width, height);
        try (Document document = new Document(pagesize, 50.0f, 50.0f, 50.0f, 50.0f);){
            PdfWriter writer = PdfWriter.getInstance(document, output);
            document.addAuthor("JFreeChart");
            document.addSubject(this.chartName);
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate(width, height);
            Graphics2D g2 = tp.createGraphics(width, height);
            Rectangle2D.Double r2D = new Rectangle2D.Double(0.0, 0.0, width, height);
            chart.draw(g2, r2D);
            g2.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
        }
    }

    public void setFileFormat(ImageFormat ff) {
        try {
            this.fileFormat = ff;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setChartNameVisible(boolean cn) {
        try {
            this.chartNameIsVisible = cn;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setChartName(String name) {
        try {
            this.chartName = name;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setChartNameFont(Font cnf) {
        try {
            this.chartNameFont = cnf;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setChartBackgroundColor(Color cc) {
        try {
            this.chartBackgroundPaintColor = cc;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setChartOutlineIsVisible(boolean ov) {
        try {
            this.chartOutlineIsVisible = ov;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setChartOutlineColor(Color coc) {
        try {
            this.chartOutlineColor = coc;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPlotBackgroundColor(Color pc) {
        try {
            this.plotBackgroundPaintColor = pc;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPlotOutlineIsVisible(boolean ov) {
        try {
            this.plotOutlineIsVisible = ov;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPlotOutlineColor(Color poc) {
        try {
            this.plotOutlineColor = poc;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setLegendVisible(boolean lv) {
        try {
            this.legendIsVisible = lv;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setLegendFrameVisible(boolean lfv) {
        try {
            this.legendFrameIsVisible = lfv;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setLegendNameFont(Font lnf) {
        try {
            this.legendNameFont = lnf;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setWidthAndHeight(int w, int h) {
        try {
            this.width = w;
            this.height = h;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setVerticalGridLineVisible(boolean vgl) {
        try {
            this.verticalGridlineIsVisible = vgl;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setHorizontalGridLineVisible(boolean hgl) {
        try {
            this.horizontalGridlineIsVisible = hgl;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setVerticalGridlineColor(Color vgc) {
        try {
            this.verticalGridlineColor = vgc;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setHorizontalGridlineColor(Color hgc) {
        try {
            this.horizontalGridlineColor = hgc;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setXAxisName(String x) {
        try {
            this.xAxisName = x;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setYAxisName(String y) {
        try {
            this.yAxisName = y;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setXAxisNameFont(Font xa) {
        try {
            this.xAxisNameFont = xa;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setYAxisNameFont(Font ya) {
        try {
            this.yAxisNameFont = ya;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setXAxisTickFont(Font xtf) {
        try {
            this.xAxisTickMarkFont = xtf;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setYAxisTickFont(Font ytf) {
        try {
            this.yAxisTickMarkFont = ytf;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setXAxisUpperBound(double xu) {
        try {
            this.xAxisUpperBound = xu;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setXAxisLowerBound(double xl) {
        try {
            this.xAxisLowerBound = xl;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setXAxisTickUnit(double xt) {
        try {
            this.xAxisTickUnit = xt;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setYAxisUpperBound(double yu) {
        try {
            this.yAxisUpperBound = yu;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setYAxisLowerBound(double yl) {
        try {
            this.yAxisLowerBound = yl;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setYAxisTickUnit(double yt) {
        try {
            this.yAxisTickUnit = yt;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setXAxisColor(Color xc) {
        try {
            this.xAxisColor = xc;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setYAxisColor(Color yc) {
        try {
            this.yAxisColor = yc;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setUseDefaultColors(boolean dc) {
        try {
            this.defaultColors = dc;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setUseDefaultShapes(boolean ds) {
        try {
            this.defaultShapes = ds;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setMargin(double um, double lm) {
        try {
            this.upperMargin = um;
            this.lowerMargin = lm;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setYAxisNumFormat(String ynf) {
        try {
            this.yAxisNumFormat = ynf;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setXAxisNumFormat(String xnf) {
        try {
            this.xAxisNumFormat = xnf;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setXAxisTickLabelColor(Color xtc) {
        try {
            this.xAxisTickLabelColor = xtc;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setYAxisTickLabelColor(Color ytc) {
        try {
            this.yAxisTickLabelColor = ytc;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setLegendLocation(RectangleEdge ll) {
        try {
            this.legendLocation = ll;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setXAxisLabelLocation(AxisLabelLocation xll) {
        try {
            this.xAxisLabelLocation = xll;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setYAxisLabelLocation(AxisLabelLocation yll) {
        try {
            this.yAxisLabelLocation = yll;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setLeftMargin(double lm) {
        try {
            this.leftMargin = lm;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setRightMargin(double rm) {
        try {
            this.rightMargin = rm;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

