/*
 * Decompiled with CFR 0.152.
 */
package org.fda.evaluator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.fda.alignment.ScaffoldContig;
import org.fda.data.QUAL;
import org.fda.data.ReferenceSet;
import org.fda.data.Utilities;
import org.fda.evaluator.EvaluatorBase;
import org.fda.evaluator.IntervalMerger;

public class Processor {
    private final File outdir;
    private final Map<QUAL, IntervalMerger> qualIntMergerMap;
    private final ReferenceSet refSet;
    private long totContigSizeWOgaps = 0L;

    public long getTotContigSizeWOgaps() {
        return this.totContigSizeWOgaps;
    }

    public Processor(EvaluatorBase ev, ReferenceSet cset, File outdir) {
        this.refSet = cset;
        this.outdir = outdir;
        this.qualIntMergerMap = new TreeMap<QUAL, IntervalMerger>();
        for (QUAL c : Utilities.qlevel.getQlevels()) {
            try {
                this.qualIntMergerMap.put(c, new IntervalMerger(cset, c, ev));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void process(ScaffoldContig ast) {
        this.totContigSizeWOgaps += (long)(ast.getContigLength() - ast.getNcount());
        List<QUAL> levels = Utilities.qlevel.allValidLevels(ast.getQuality());
        for (QUAL c : levels) {
            try {
                this.qualIntMergerMap.get(c).process(ast, true);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private List<Double> getRatio(boolean rev, boolean diff, int cov) {
        ArrayList<Double> ret = new ArrayList<Double>();
        QUAL c = rev ? Utilities.qlevel.getHighest() : Utilities.qlevel.getLowest();
        double p = 0.0;
        double curr = 0.0;
        while (c != null) {
            IntervalMerger im = this.qualIntMergerMap.get(c);
            curr = cov == 0 ? im.getTotCovRatio() : (cov == 1 ? im.getInvDupRatio() : im.getValidityRatio());
            if (diff) {
                ret.add(curr - p);
            } else {
                ret.add(curr);
            }
            p = curr;
            c = rev ? c.getPrev() : c.getNext();
        }
        return ret;
    }

    public void finalizeProcess() {
        for (IntervalMerger im : this.qualIntMergerMap.values()) {
            im.finalize_process(this.getTotContigSizeWOgaps());
        }
    }

    public List<Double> getCoverageRatio() {
        return this.getRatio(true, false, 0);
    }

    public List<Double> getInvDupRatio() {
        return this.getRatio(true, false, 1);
    }

    public List<Double> getValidityRatio() {
        return this.getRatio(true, false, 2);
    }
}

