/*
 * Decompiled with CFR 0.152.
 */
package org.fda.evaluator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import org.fda.data.Enums;
import org.fda.data.QUAL;
import org.fda.data.ReferenceSet;
import org.fda.data.Utilities;
import org.fda.evaluator.Processor;
import org.fda.evaluator.QLPair;
import org.fda.graphdrawing.chart.TwoDCategoryLinePlot;
import org.fda.graphdrawing.data.CategoryLineChartDataset;
import org.fda.graphdrawing.data.CategoryLineChartDatasetSeries;
import org.fda.graphdrawing.data.CustomHistogramDataset;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.statistics.HistogramType;
import org.jfree.ui.RectangleEdge;

public abstract class EvaluatorBase {
    protected File contigfile;
    protected File alignmentfile;
    protected File outfile;
    protected File missassemblyFile;
    protected File outdir;
    protected final ReferenceSet chrset;
    protected File sourceFolder;
    protected BufferedWriter bw;
    protected BufferedWriter bwc;
    protected BufferedWriter misassemblyBw;
    protected boolean writeToDest = true;
    protected Processor p;
    protected final RectangleEdge aucPosition = RectangleEdge.BOTTOM;

    public EvaluatorBase(File sourceFolder, File outdir, ReferenceSet chrset) throws IOException {
        this.sourceFolder = sourceFolder;
        this.outdir = outdir;
        this.chrset = chrset;
    }

    public boolean processFiles() {
        Object quals = null;
        try {
            String line;
            this.bw = new BufferedWriter(new FileWriter(this.outfile));
            this.bw.append("Scaffold ID\tScaffold Size\tAligned Scaffold Size\tAlignment Percentage\tGC Ratio\tAmbiguous Base (N) Ratio\tQuality Score");
            for (Enums.Inconsistency nci : Enums.Inconsistency.values()) {
                this.bw.append("\t" + nci);
            }
            this.bw.append("\tTotal Misassembly");
            this.bw.append(Utilities.ls);
            this.bwc = new BufferedWriter(new FileWriter(this.alignmentfile));
            this.bwc.append("Scaffold ID\tChromosome ID\tChromosome Start\tChromosomeEnd\tChromosome Frame\tScaffold Start\tScaffold End\tScaffold Frame\tIdentity%\tStartTrimmed\tEndTrimmed" + Utilities.ls);
            this.misassemblyBw = new BufferedWriter(new FileWriter(this.missassemblyFile));
            this.misassemblyBw.append("Scaffold ID\tMisassembly Type\tScaffoldCoordinates1\tScaffoldCoordinates2\tAlignmentCoords1\tAlignmentCoords2" + Utilities.ls);
            QLPair[] quallist = this.process();
            this.drawQualityScoreHistogram(quallist, false);
            this.drawQualityScoreHistogram(quallist, true);
            this.bw.close();
            this.bwc.close();
            this.misassemblyBw.close();
            this.p.finalizeProcess();
            double covArea = this.calculateAreaUnderCurve(this.p.getCoverageRatio());
            double validityArea = this.calculateAreaUnderCurve(this.p.getValidityRatio());
            List<Double> tmplist = this.p.getInvDupRatio();
            double invDup = tmplist.get(tmplist.size() - 1);
            List<Double> darr = this.histAlternative(quallist);
            double relFreqArea = this.calculateAreaUnderCurve(darr);
            this.drawChart(this.p.getCoverageRatio(), covArea, "Genome Coverage Ratio at Quality Thresholds", "", 1.0, "genomecoverageratio@Qthresholds");
            this.drawChart(this.p.getValidityRatio(), validityArea, "Validity Ratio at Quality Thresholds", "", 1.0, "validityratio@Qthresholds");
            this.drawChart(darr, relFreqArea, "Cumulative size ratio of Contigs/Scaffolds at Quality Thresholds", "", 1.0, "cumsizeratio@Qthresholds");
            double finalscoreHarm = 3.0 / (1.0 / covArea + 1.0 / invDup + 1.0 / relFreqArea);
            double finalscoreGeo = Math.cbrt(covArea * invDup * relFreqArea);
            double finalscoreArith = (covArea + invDup + relFreqArea) / 3.0;
            File f1 = new File(this.outdir.getAbsolutePath() + File.separator + Utilities.assemblystatsFile);
            File tmp = new File(this.outdir.getAbsolutePath() + File.separator + Utilities.assemblystatsFile + ".tmp");
            BufferedWriter bo = new BufferedWriter(new FileWriter(tmp));
            BufferedReader br = new BufferedReader(new FileReader(f1));
            while ((line = br.readLine()) != null && !(line = line.trim()).startsWith("Final quality score for the assembly")) {
                if (line.isEmpty()) continue;
                bo.append(line + Utilities.ls);
            }
            br.close();
            List<Double> coverage = this.p.getCoverageRatio();
            List<Double> validity = this.p.getValidityRatio();
            bo.append(Utilities.ls + "Final quality score for the assembly= " + Utilities.numberFormatter.format(finalscoreGeo));
            bo.append(Utilities.ls + "Genome coverage ratio for the assembly= " + Utilities.numberFormatter.format(coverage.get(coverage.size() - 1)));
            bo.append(Utilities.ls + "Duplication ratio for the assembly= " + Utilities.numberFormatter.format(1.0 / invDup));
            bo.append(Utilities.ls + "Validity ratio for the assembly= " + Utilities.numberFormatter.format(validity.get(validity.size() - 1)));
            bo.close();
            Files.copy(tmp.toPath(), f1.toPath(), StandardCopyOption.REPLACE_EXISTING);
            tmp.delete();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.writeToDest;
    }

    private List<Double> hist(QLPair[] quals) {
        int ind;
        QUAL c;
        ArrayList<Double> d = new ArrayList<Double>();
        for (c = Utilities.qlevel.getHighest(); c != null; c = c.getPrev()) {
            d.add(0.0);
        }
        for (QLPair q : quals) {
            ind = 0;
            c = Utilities.qlevel.getHighest();
            while (c != null) {
                if (q.getQuality() >= c.getValue()) {
                    d.set(ind, (Double)d.get(ind) + 1.0);
                }
                c = c.getPrev();
                ++ind;
            }
        }
        c = Utilities.qlevel.getHighest();
        ind = 0;
        while (c != null) {
            d.set(ind, (Double)d.get(ind) / (double)quals.length);
            c = c.getPrev();
            ++ind;
        }
        return d;
    }

    private List<Double> histAlternative(QLPair[] quals) {
        int ind;
        QUAL c;
        ArrayList<Double> d = new ArrayList<Double>();
        for (c = Utilities.qlevel.getHighest(); c != null; c = c.getPrev()) {
            d.add(0.0);
        }
        for (QLPair q : quals) {
            ind = 0;
            c = Utilities.qlevel.getHighest();
            while (c != null) {
                if (q.getQuality() >= c.getValue()) {
                    d.set(ind, (Double)d.get(ind) + (double)q.getLength());
                }
                c = c.getPrev();
                ++ind;
            }
        }
        double maxValue = (Double)d.get(d.size() - 1);
        c = Utilities.qlevel.getHighest();
        ind = 0;
        while (c != null) {
            d.set(ind, (Double)d.get(ind) / maxValue);
            c = c.getPrev();
            ++ind;
        }
        return d;
    }

    private double calculateAreaUnderCurve(List<Double> d) {
        double sum = 0.0;
        for (int i = 1; i < d.size(); ++i) {
            sum += (d.get(i) + d.get(i - 1)) * Utilities.difference / 2.0;
        }
        return sum;
    }

    private void drawChart(List<Double> darr, double auc, String chartName, String yaxisname, double maxYvalue, String filename) {
        ArrayList<String> colNames = new ArrayList<String>();
        CategoryLineChartDataset data = new CategoryLineChartDataset();
        for (QUAL c = Utilities.qlevel.getHighest(); c != null; c = c.getPrev()) {
            colNames.add("Q>=" + c.getValue());
        }
        CategoryLineChartDatasetSeries cd = new CategoryLineChartDatasetSeries("", colNames, darr);
        data.addSeries(cd);
        TextTitle legendText = new TextTitle("Area Under Curve: " + Utilities.numberFormatter.format(auc));
        legendText.setPosition(this.aucPosition);
        try {
            File targetFile = new File(this.outdir.getAbsolutePath() + File.separator + "charts" + File.separator + filename + Utilities.format.getExtension());
            TwoDCategoryLinePlot plot = new TwoDCategoryLinePlot(data, targetFile);
            plot.setYAxisName(yaxisname);
            plot.setXAxisName("");
            plot.setChartName(chartName);
            plot.setXAxisLabelRotation(3);
            if (maxYvalue > 0.0) {
                plot.setYAxisUpperBound(maxYvalue);
            }
            plot.addLegendText(legendText);
            plot.draw();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract QLPair[] process();

    private void drawQualityScoreHistogram(double[] quallist) {
        CustomHistogramDataset dataset = new CustomHistogramDataset();
        dataset.setType(HistogramType.FREQUENCY);
        dataset.addSeries((Comparable)((Object)"Quality Score Frequency"), quallist, Utilities.no_hist_bins, 0.0, Utilities.maxQScore);
        JFreeChart chart = ChartFactory.createHistogram("Quality Score Histogram ", null, null, dataset, PlotOrientation.VERTICAL, true, false, false);
        chart.getXYPlot().setForegroundAlpha(0.75f);
        chart.getXYPlot().getDomainAxis().setRange(0.0, Utilities.maxQScore);
        File targetFile = new File(this.outdir.getAbsolutePath() + File.separator + "charts" + File.separator + "qualityScoreHistogram" + Utilities.format.getExtension());
        Utilities.saveAsFile(chart, targetFile, dataset.toTable(Utilities.intervalLength4Histogram));
    }

    private void drawQualityScoreHistogram(QLPair[] qlpairlist, boolean relFreq) {
        double[] quallist = new double[qlpairlist.length];
        for (int z = 0; z < qlpairlist.length; ++z) {
            quallist[z] = qlpairlist[z].getQuality();
        }
        if (relFreq) {
            CustomHistogramDataset dataset = new CustomHistogramDataset();
            dataset.setType(HistogramType.RELATIVE_FREQUENCY);
            dataset.addSeries((Comparable)((Object)"Quality Score Frequency"), quallist, Utilities.no_hist_bins, 0.0, Utilities.maxQScore);
            JFreeChart chart = ChartFactory.createHistogram("Quality Score Histogram ", null, null, dataset, PlotOrientation.VERTICAL, true, false, false);
            chart.getXYPlot().setForegroundAlpha(0.75f);
            chart.getXYPlot().getDomainAxis().setRange(0.0, Utilities.maxQScore);
            File targetFile = new File(this.outdir.getAbsolutePath() + File.separator + "charts" + File.separator + "qualityScoreHistogram_RelativeFreq" + Utilities.format.getExtension());
            Utilities.saveAsFile(chart, targetFile, dataset.toTable(Utilities.intervalLength4Histogram));
        } else {
            this.drawQualityScoreHistogram(quallist);
        }
    }
}

