/*
 * Decompiled with CFR 0.152.
 */
package org.fda.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.fda.data.TimePoint;
import org.fda.data.Utilities;

public class TimeKeeper {
    private final Map<String, TimePoint> timePoints;
    private final String commandName;

    public TimeKeeper(String commandName) {
        this.commandName = commandName;
        this.timePoints = new TreeMap<String, TimePoint>();
        this.timePoints.put(commandName, new TimePoint(commandName, System.nanoTime()));
    }

    public boolean addStartTimePoint(String label) {
        this.timePoints.put(label, new TimePoint(label, System.nanoTime()));
        return true;
    }

    public boolean addEndTimePoint(String label) {
        if (this.timePoints.containsKey(label)) {
            this.timePoints.get(label).setEnd(System.nanoTime());
            return true;
        }
        return false;
    }

    public boolean stopTimer() {
        return this.addEndTimePoint(this.commandName);
    }

    public String getPoints() {
        ArrayList<TimePoint> tpArr = new ArrayList<TimePoint>(this.timePoints.values());
        StringBuilder sb = new StringBuilder();
        Collections.sort(tpArr);
        for (int i = tpArr.size() - 1; i >= 0; --i) {
            sb.append(tpArr.get(i) + Utilities.ls);
        }
        return sb.toString();
    }
}

