/*
 * Decompiled with CFR 0.152.
 */
package org.fda.data;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.fda.commands.ComputeModelCommand;
import org.fda.data.Enums;
import org.fda.data.Reference;
import org.fda.data.ReferenceFile;
import org.fda.data.Utilities;
import org.fda.inputdataparser.FastaRecord;
import org.fda.inputdataparser.InputReader;
import org.fda.inputdataparser.ReadRecord;
import org.fda.intervaltree.Interval;
import org.fda.intervaltree.IntervalSearchTree;

public class ReferenceSet
implements Serializable {
    private static final long serialVersionUID = 8234343511122882189L;
    private final File infile;
    private final File outdir;
    private final Map<String, Reference> chrs = new TreeMap<String, Reference>();
    private final List<ReferenceFile> referenceFiles = new ArrayList<ReferenceFile>();
    private int maxContigSize = 0;
    private int minContigSize = Integer.MAX_VALUE;
    private final File refFolder;
    private final Set<String> hashCodeSet;
    private long genomesize = 0L;
    private long gapsize = 0L;

    public long getGapsize() {
        return this.gapsize;
    }

    public long getGenomesize() {
        return this.genomesize;
    }

    public Set<String> getHashCodeSet() {
        return this.hashCodeSet;
    }

    public File getRefFolder() {
        return this.refFolder;
    }

    public File getInfile() {
        return this.infile;
    }

    public int getMaxContigSize() {
        return this.maxContigSize;
    }

    public int getMinContigSize() {
        return this.minContigSize;
    }

    public List<ReferenceFile> getReferenceFiles() {
        return this.referenceFiles;
    }

    public List<Reference> getRefs() {
        ArrayList<Reference> ret = new ArrayList<Reference>(this.chrs.values());
        Collections.sort(ret);
        return ret;
    }

    public Reference findReference(String name) {
        return this.chrs.get(name);
    }

    public int getNumberOfReferences() {
        return this.chrs.entrySet().size();
    }

    private ReferenceFile findBestFitGreedy(ReadRecord r) {
        long fit = 0L;
        long bestFit = 0L;
        ReferenceFile tmp = null;
        ReferenceFile toRet = null;
        boolean first = true;
        for (int i = 0; i < this.referenceFiles.size(); ++i) {
            tmp = this.referenceFiles.get(i);
            fit = 300000000L - (tmp.getSize() + (long)r.getReadRecordLength());
            if (fit > 0L && first) {
                toRet = tmp;
                bestFit = fit;
                first = false;
                continue;
            }
            if (fit <= 0L || fit >= bestFit) continue;
            toRet = tmp;
            bestFit = fit;
        }
        return toRet;
    }

    private void setMaxMinContigLength(int len) {
        if (len < this.minContigSize) {
            this.minContigSize = len;
        }
        if (len > this.maxContigSize) {
            this.maxContigSize = len;
        }
    }

    private boolean processReferenceFile() {
        InputReader fr = new InputReader();
        BufferedWriter bwchrgaps = null;
        try {
            ReadRecord f_rec;
            if (!(Utilities.current_cmd instanceof ComputeModelCommand)) {
                bwchrgaps = new BufferedWriter(new FileWriter(new File(this.outdir.getAbsolutePath() + File.separator + Utilities.chrGapsFileName)));
            }
            fr.openFile(this.infile);
            int i = 0;
            while ((f_rec = fr.readNextRecord()) != null) {
                this.setMaxMinContigLength(f_rec.getReadRecordLength());
                if (Utilities.alignmentTool == Enums.AlignmentTool.nucmer) {
                    ReferenceFile tmpRefFile = null;
                    if (tmpRefFile == null) {
                        tmpRefFile = new ReferenceFile(this.refFolder.getAbsolutePath() + File.separator + "refpart" + Utilities.giveName(i) + ".fa", Enums.FileMode.WRITE);
                        this.referenceFiles.add(tmpRefFile);
                        ++i;
                    }
                    tmpRefFile.writeTo(f_rec);
                }
                Reference c = new Reference(f_rec.getName(), f_rec.getReadRecordLength(), f_rec.getGCcount(), f_rec.getGCpercent(), ((FastaRecord)f_rec).getnIntervalsTree(), f_rec.getNcount(), ((FastaRecord)f_rec).getHashValue(), ((FastaRecord)f_rec).getSeqHashValue());
                this.chrs.put(c.getRefID(), c);
                this.genomesize += c.getLength();
                this.gapsize += c.getGaplength();
                this.hashCodeSet.add(Utilities.byteToHex(c.getHashValue()));
                IntervalSearchTree ist = c.getGapIntervalTree();
                if (bwchrgaps == null) continue;
                bwchrgaps.append(c.getRefID() + Utilities.ls);
                for (Interval inte : ist.inOrder()) {
                    bwchrgaps.append("\t" + inte + Utilities.ls);
                }
            }
            fr.closeReader();
            if (Utilities.alignmentTool == Enums.AlignmentTool.nucmer) {
                for (ReferenceFile rf : this.referenceFiles) {
                    rf.closeFastaWriter();
                }
            } else {
                this.referenceFiles.add(new ReferenceFile(this.infile, Enums.FileMode.READONLY));
            }
            File otu = new File(this.outdir.getAbsolutePath() + File.separator + Utilities.chrStatFileName);
            ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(otu)));
            out.writeObject(this);
            out.close();
            if (bwchrgaps != null) {
                bwchrgaps.close();
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public ReferenceSet(File infile, File outdir) throws ExceptionInInitializerError {
        this.outdir = outdir;
        this.infile = infile;
        this.hashCodeSet = new HashSet<String>();
        this.refFolder = new File(outdir.getAbsolutePath() + File.separator + "REF");
        this.refFolder.mkdirs();
        boolean out = this.processReferenceFile();
        if (!out) {
            throw new ExceptionInInitializerError();
        }
    }

    public static ReferenceSet load(File indir) {
        ReferenceSet rset;
        block15: {
            rset = null;
            try (ObjectInputStream instream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(indir.getAbsolutePath() + File.separator + Utilities.chrStatFileName)));){
                rset = (ReferenceSet)instream.readObject();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException ex) {
                if (ex instanceof EOFException) break block15;
                ex.printStackTrace();
            }
        }
        return rset;
    }

    public boolean equals(ReferenceSet r) {
        if (this.hashCodeSet.size() != r.hashCodeSet.size()) {
            return false;
        }
        for (String s : this.hashCodeSet) {
            if (r.getHashCodeSet().contains(s)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(ReferenceSet r) {
        return this.hashCodeSet.containsAll(r.getHashCodeSet());
    }
}

