/*
 * Decompiled with CFR 0.152.
 */
package org.fda.data;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.fda.data.Enums;
import org.fda.data.Reference;
import org.fda.inputdataparser.FastaWriter;
import org.fda.inputdataparser.ReadRecord;

public class ReferenceFile
implements Comparable<ReferenceFile>,
Serializable {
    private final File file;
    private final List<Reference> references;
    private final FastaWriter fw;
    private static final long serialVersionUID = 112411362619L;
    private Enums.FileMode mode;

    public File getFile() {
        return this.file;
    }

    public void closeFastaWriter() {
        this.fw.closeWriter();
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public List<Reference> getReferences() {
        return this.references;
    }

    public void addReference(Reference r) {
        this.references.add(r);
    }

    public ReferenceFile(String filename, Enums.FileMode m) {
        this.file = new File(filename);
        this.references = new ArrayList<Reference>();
        this.mode = m;
        this.fw = this.mode == Enums.FileMode.WRITE ? new FastaWriter(this.file) : null;
    }

    public ReferenceFile(File f, Enums.FileMode m) {
        this.file = f;
        this.references = new ArrayList<Reference>();
        this.mode = m;
        this.fw = this.mode == Enums.FileMode.WRITE ? new FastaWriter(this.file) : null;
    }

    public void writeTo(ReadRecord r) {
        this.fw.write(r);
    }

    public long getSize() {
        return this.fw.getSize();
    }

    @Override
    public int compareTo(ReferenceFile o) {
        return this.file.getName().compareToIgnoreCase(o.getFile().getName());
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReferenceFile other = (ReferenceFile)obj;
        return Objects.equals(this.file, other.file);
    }
}

