/*
 * Decompiled with CFR 0.152.
 */
package org.fda.data;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fda.data.Enums;
import org.fda.data.Utilities;
import org.fda.intervaltree.IntervalSearchTree;

public class Reference
implements Comparable<Reference>,
Serializable {
    private final String refID;
    private final long length;
    private final long gaplength;
    private final long gc_count;
    private final double gc_percent;
    private long coveredLength;
    private double coveragePerc;
    private double duplicationRatio;
    private long totalAlignedLength;
    private Enums.CoverageType cov_type = Enums.CoverageType.NONE;
    private static final long serialVersionUID = 8234343511122882189L;
    private long id = -1L;
    private byte[] hashValue = null;
    private byte[] seqHashValue = null;
    private final IntervalSearchTree gapIntervalTree;

    public Reference(String refID, long length, long gc_count, double gc_percent, IntervalSearchTree nIntervalsTree, long gaplength) {
        this.refID = refID;
        this.length = length;
        this.gc_count = gc_count;
        this.gc_percent = gc_percent;
        this.id = this.extractDigits(refID);
        this.gapIntervalTree = nIntervalsTree;
        this.gaplength = gaplength;
    }

    public Reference(String refID, long length, long gc_count, double gc_percent, IntervalSearchTree nIntervalsTree, long gaplength, byte[] hashValue, byte[] seqHashValue) {
        this(refID, length, gc_count, gc_percent, nIntervalsTree, gaplength);
        this.hashValue = hashValue;
        this.seqHashValue = seqHashValue;
    }

    public long getGaplength() {
        return this.gaplength;
    }

    public IntervalSearchTree getGapIntervalTree() {
        return this.gapIntervalTree;
    }

    public byte[] getSeqHashValue() {
        return this.seqHashValue;
    }

    public byte[] getHashValue() {
        return this.hashValue;
    }

    public Enums.CoverageType getCoverageType() {
        return this.cov_type;
    }

    public void setCoverageType(Enums.CoverageType c) {
        this.cov_type = c;
    }

    public long getTotalAlignedLength() {
        return this.totalAlignedLength;
    }

    public void setTotalAlignedLength(long totalAlignedLength) {
        this.totalAlignedLength = totalAlignedLength;
        if (this.coveredLength > 0L) {
            this.setDuplicationRatio((double)totalAlignedLength / (double)this.coveredLength);
        } else {
            this.setDuplicationRatio(Double.NaN);
        }
    }

    public double getDuplicationRatio() {
        return this.duplicationRatio;
    }

    public void setDuplicationRatio(double duplicationRatio) {
        this.duplicationRatio = duplicationRatio;
    }

    public double getCoveragePerc() {
        return this.coveragePerc;
    }

    public void setCoveragePerc(double coveragePerc) {
        this.coveragePerc = coveragePerc;
        this.setCoverageType(Enums.CoverageType.getCoverageType(coveragePerc));
    }

    public long getCoveredLength() {
        return this.coveredLength;
    }

    public void setCoveredLength(long coveredLength) {
        this.coveredLength = coveredLength;
        this.setCoveragePerc(Utilities.calcPercentage(coveredLength, this.length));
    }

    public double getGCpercent() {
        return this.gc_percent;
    }

    public long getGCcount() {
        return this.gc_count;
    }

    public long getLength() {
        return this.length;
    }

    public String getRefID() {
        return this.refID;
    }

    public String toString() {
        return this.refID;
    }

    public long getID() {
        return this.id;
    }

    private long extractDigits(String s) {
        Pattern p = Pattern.compile("\\d+");
        Matcher m = p.matcher(s);
        long max = -1L;
        while (m.find()) {
            long curr = Long.parseLong(m.group());
            if (curr <= max) continue;
            max = curr;
        }
        return max;
    }

    @Override
    public int compareTo(Reference o) {
        if (this.id == -1L && o.getID() == -1L) {
            return this.refID.compareToIgnoreCase(o.getRefID());
        }
        if (this.id == -1L) {
            return 1;
        }
        if (o.getID() == -1L) {
            return -1;
        }
        return Long.compare(this.id, o.getID());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Reference other = (Reference)obj;
        if (!Objects.equals(this.refID, other.refID)) {
            return false;
        }
        return this.length == other.length;
    }

    public int hashCode() {
        return this.refID.hashCode();
    }

    public boolean equalsTo(Reference r) {
        return Arrays.equals(this.hashValue, r.getHashValue());
    }

    public boolean seqEqualsTo(Reference r) {
        return Arrays.equals(this.seqHashValue, r.getSeqHashValue());
    }
}

