/*
 * Decompiled with CFR 0.152.
 */
package org.fda.data;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;
import org.fda.data.QUAL;
import org.fda.data.Utilities;

public class QUALLEVEL {
    private final BigDecimal highestValue;
    private final BigDecimal lowestValue;
    private final BigDecimal difference;
    private final QUAL highest;
    private final QUAL lowest;
    private final List<QUAL> qlevels = new ArrayList<QUAL>();

    public QUAL getHighest() {
        return this.highest;
    }

    public QUAL getLowest() {
        return this.lowest;
    }

    public List<QUAL> getQlevels() {
        return this.qlevels;
    }

    public QUALLEVEL(double highestValue, double lowestValue, double difference) {
        int i;
        this.highestValue = new BigDecimal(highestValue, new MathContext(2));
        this.lowestValue = new BigDecimal(lowestValue, new MathContext(2));
        this.difference = new BigDecimal(difference, new MathContext(2));
        BigDecimal d = this.lowestValue;
        while (d.doubleValue() <= highestValue) {
            this.qlevels.add(new QUAL(d));
            d = d.add(this.difference);
        }
        this.lowest = this.qlevels.get(0);
        this.highest = this.qlevels.get(this.qlevels.size() - 1);
        for (i = 1; i < this.qlevels.size(); ++i) {
            this.qlevels.get(i).setPrev(this.qlevels.get(i - 1));
        }
        for (i = 0; i < this.qlevels.size() - 1; ++i) {
            this.qlevels.get(i).setNext(this.qlevels.get(i + 1));
        }
    }

    public List<QUAL> allValidLevels(double d) {
        ArrayList<QUAL> ret = new ArrayList<QUAL>();
        for (int i = 0; i < this.qlevels.size(); ++i) {
            if (!(d >= this.qlevels.get(i).getValue())) continue;
            ret.add(this.qlevels.get(i));
        }
        return ret;
    }

    public static void main(String[] args) {
        for (QUAL q : Utilities.qlevel.getQlevels()) {
            System.out.println(q.getValue());
        }
    }
}

