/*
 * Decompiled with CFR 0.152.
 */
package org.fda.data;

import java.io.Serializable;
import org.fda.alignment.Alignment;
import org.fda.data.Enums;
import org.fda.intervaltree.Interval;

public class Misassembly
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Enums.Inconsistency type;
    private final Alignment A1;
    private final Alignment A2;

    public Misassembly(Enums.Inconsistency type, Alignment a1, Alignment a2) {
        this.type = type;
        this.A1 = a1;
        this.A2 = a2;
    }

    public Enums.Inconsistency getType() {
        return this.type;
    }

    public Alignment getA1() {
        return this.A1;
    }

    public Alignment getA2() {
        return this.A2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type + "\t");
        Interval contigInt = this.A1.getContigInterval();
        sb.append(contigInt.toString() + "\t");
        contigInt = this.A2.getContigInterval();
        sb.append(contigInt.toString() + "\t");
        Interval refInt = this.A1.getReferenceInterval();
        sb.append(this.A1.getReference().getRefID() + ":" + refInt.toString() + "\t");
        refInt = this.A2.getReferenceInterval();
        sb.append(this.A2.getReference().getRefID() + ":" + refInt.toString());
        return sb.toString();
    }
}

