/*
 * Decompiled with CFR 0.152.
 */
package org.fda.contiggenerator;

import java.io.File;
import java.util.Random;
import org.apache.commons.math3.distribution.GammaDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.RandomGeneratorFactory;
import org.fda.contiggenerator.ContigGenerator;
import org.fda.data.Enums;
import org.fda.data.Utilities;

public abstract class ContigGeneratorWDistribution
extends ContigGenerator {
    protected final Random rand;
    protected final GammaDistribution grand;
    protected double mean;
    protected double sd;
    protected final Enums.Distribution dist;
    protected boolean setseed = false;

    public double getMean() {
        return this.mean;
    }

    public double getSd() {
        return this.sd;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    public void setSd(double sd) {
        this.sd = sd;
    }

    public ContigGeneratorWDistribution(File infile, File outfile, double mean, double sd, Enums.Distribution dist) {
        super(infile, outfile);
        this.dist = dist;
        this.mean = mean;
        this.sd = sd;
        this.rand = new Random();
        if (dist == Enums.Distribution.GAMMA) {
            RandomGenerator r = RandomGeneratorFactory.createRandomGenerator(this.rand);
            this.grand = new GammaDistribution(r, this.sd, this.mean);
        } else {
            this.grand = null;
        }
    }

    public ContigGeneratorWDistribution(File infile, File outfile, double mean, double sd, Enums.Distribution dist, boolean createreport) {
        super(infile, outfile, createreport);
        this.dist = dist;
        this.mean = mean;
        this.sd = sd;
        this.rand = new Random();
        if (dist == Enums.Distribution.GAMMA) {
            RandomGenerator r = RandomGeneratorFactory.createRandomGenerator(this.rand);
            this.grand = new GammaDistribution(r, this.sd, this.mean);
        } else {
            this.grand = null;
        }
    }

    public ContigGeneratorWDistribution(File infile, File outfile, double mean, double sd, Enums.Distribution dist, long seed) {
        super(infile, outfile);
        this.dist = dist;
        this.mean = mean;
        this.sd = sd;
        this.rand = new Random(seed);
        if (dist == Enums.Distribution.GAMMA) {
            RandomGenerator r = RandomGeneratorFactory.createRandomGenerator(this.rand);
            this.grand = new GammaDistribution(r, this.sd, this.mean);
        } else {
            this.grand = null;
        }
    }

    public ContigGeneratorWDistribution(File infile, File outfile, double mean, double sd, Enums.Distribution dist, long seed, boolean createreport) {
        super(infile, outfile, createreport);
        this.dist = dist;
        this.mean = mean;
        this.sd = sd;
        this.rand = new Random(seed);
        if (dist == Enums.Distribution.GAMMA) {
            RandomGenerator r = RandomGeneratorFactory.createRandomGenerator(this.rand);
            this.grand = new GammaDistribution(r, this.sd, this.mean);
        } else {
            this.grand = null;
        }
    }

    public ContigGeneratorWDistribution(File infile, File outfile, double mean, double sd, Enums.Distribution dist, boolean setseed, boolean createreport) {
        this(infile, outfile, mean, sd, dist, createreport);
        this.setseed = setseed;
    }

    private int getGammaDistRandomLength(long l) {
        int contlen;
        while ((contlen = (int)this.grand.sample()) < Utilities.determineAllowedMinSimContigLength(l)) {
        }
        return contlen;
    }

    private int getNormalDistRandomLength(long l) {
        int contlen;
        while ((contlen = (int)Math.round(this.rand.nextGaussian() * this.sd + this.mean)) < Utilities.determineAllowedMinSimContigLength(l)) {
        }
        return contlen;
    }

    private int getUniformDistRandomLength(long l) {
        int contlen;
        while ((contlen = this.rand.nextInt((int)this.mean + 1)) < Utilities.determineAllowedMinSimContigLength(l)) {
        }
        return contlen;
    }

    private int getGammaDistRandomLength(long l, double target_cov, long current_length) {
        double posscov;
        int contlen;
        while ((contlen = (int)this.grand.sample()) < Utilities.determineAllowedMinSimContigLength(l) || !((posscov = (double)((long)contlen + current_length) / (double)l) / target_cov <= 1.0 + Utilities.simulation_coverage_ratio_threshold)) {
        }
        return contlen;
    }

    private int getNormalDistRandomLength(long l, double target_cov, long current_length) {
        double posscov;
        int contlen;
        while ((contlen = (int)Math.round(this.rand.nextGaussian() * this.sd + this.mean)) < Utilities.determineAllowedMinSimContigLength(l) || !((posscov = (double)((long)contlen + current_length) / (double)l) / target_cov <= 1.0 + Utilities.simulation_coverage_ratio_threshold)) {
        }
        return contlen;
    }

    private int getUniformDistRandomLength(long l, double target_cov, long current_length) {
        double posscov;
        int contlen;
        while ((contlen = this.rand.nextInt((int)this.mean + 1)) < Utilities.determineAllowedMinSimContigLength(l) || !((posscov = (double)((long)contlen + current_length) / (double)l) / target_cov <= 1.0 + Utilities.simulation_coverage_ratio_threshold)) {
        }
        return contlen;
    }

    protected int getRandomLength(long ref_cont_length) {
        if (null == this.dist) {
            return this.getUniformDistRandomLength(ref_cont_length);
        }
        switch (this.dist) {
            case NORMAL: {
                return this.getNormalDistRandomLength(ref_cont_length);
            }
            case GAMMA: {
                return this.getGammaDistRandomLength(ref_cont_length);
            }
        }
        return this.getUniformDistRandomLength(ref_cont_length);
    }

    protected int getRandomLength(long ref_cont_length, double target_cov, long current_length) {
        if (null == this.dist) {
            return this.getUniformDistRandomLength(ref_cont_length, target_cov, current_length);
        }
        switch (this.dist) {
            case NORMAL: {
                return this.getNormalDistRandomLength(ref_cont_length, target_cov, current_length);
            }
            case GAMMA: {
                return this.getGammaDistRandomLength(ref_cont_length, target_cov, current_length);
            }
        }
        return this.getUniformDistRandomLength(ref_cont_length, target_cov, current_length);
    }
}

