/*
 * Decompiled with CFR 0.152.
 */
package org.fda.contiggenerator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.fda.contiggenerator.ContigDetails;
import org.fda.contiggenerator.ContigGenerator4;
import org.fda.data.Enums;
import org.fda.data.Utilities;
import org.fda.exceptions.IllegalIntervalException;
import org.fda.inputdataparser.FastaReader;
import org.fda.inputdataparser.FastaRecord;
import org.fda.inputdataparser.FastaWriter;
import org.fda.intervaltree.Interval;

public class ContigGeneratorForModel
extends ContigGenerator4 {
    private final Map<String, List<String>> map = new TreeMap<String, List<String>>();

    public Map<String, List<String>> getRefContigIDMap() {
        return this.map;
    }

    public ContigGeneratorForModel(File infile, File outfile) {
        super(infile, outfile, 0.0, 0.0, Enums.Distribution.UNIFORM, true, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRefAsContigs() {
        FastaReader fr = new FastaReader();
        FastaWriter frw = new FastaWriter(this.outfile, true);
        try {
            FastaRecord r;
            fr.openFile(this.infile);
            while ((r = (FastaRecord)fr.readNextRecord()) != null) {
                frw.write(r);
                this.totsize += (long)r.getReadRecordLength();
                this.totalN += (long)r.getNcount();
                ++this.totcontnumber;
                ContigDetails tmp = new ContigDetails(r.getName(), r.getName(), new Interval(1, r.getReadRecordLength(), false), Enums.Orientation.F, r.getNcount(), r.getNratio());
                this.finalcontigcoords.add(tmp);
                this.add2Lengths(tmp);
                this.map.get(r.getName()).add(r.getName());
            }
            fr.closeReader();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        catch (IllegalIntervalException ex) {
            ex.printStackTrace();
        }
        finally {
            frw.closeWriter();
        }
        this.report();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateContigs() {
        FastaReader fr = new FastaReader();
        FastaWriter frw = new FastaWriter(this.outfile);
        try {
            FastaRecord r;
            fr.openFile(this.infile);
            while ((r = (FastaRecord)fr.readNextRecord()) != null) {
                this.totalNReference += (long)r.getNcount();
                ++this.totrefnumber;
                this.totrefsize += (long)r.getReadRecordLength();
                this.map.put(r.getName(), new ArrayList());
                int i = 0;
                while ((double)i < Utilities.depthCoverage) {
                    if (this.setseed) {
                        this.rand.setSeed((long)r.getReadRecordLength() + (long)i);
                    }
                    this.setMean(r.getReadRecordLength());
                    this.map.get(r.getName()).addAll(this.createContigsOnReference(r, frw, 1.0));
                    ++i;
                }
            }
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        catch (IllegalIntervalException ex) {
            ex.printStackTrace();
        }
        finally {
            frw.closeWriter();
        }
        this.report();
    }
}

