/*
 * Decompiled with CFR 0.152.
 */
package org.fda.contiggenerator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.fda.contiggenerator.ContigGenerator4;
import org.fda.data.Enums;
import org.fda.data.Utilities;
import org.fda.exceptions.IllegalIntervalException;
import org.fda.inputdataparser.FastaReader;
import org.fda.inputdataparser.FastaRecord;
import org.fda.inputdataparser.FastaWriter;

public class ContigGenerator5
extends ContigGenerator4 {
    private final Map<String, List<String>> map = new TreeMap<String, List<String>>();

    public Map<String, List<String>> getRefContigIDMap() {
        return this.map;
    }

    public ContigGenerator5(File infile, File outfile) {
        super(infile, outfile, 0.0, 0.0, Enums.Distribution.UNIFORM, true, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateContigs() {
        FastaReader fr = new FastaReader();
        FastaWriter frw = new FastaWriter(this.outfile);
        int w = (int)Utilities.depthCoverage;
        double f = Utilities.depthCoverage - (double)w;
        try {
            FastaRecord r;
            fr.openFile(this.infile);
            while ((r = (FastaRecord)fr.readNextRecord()) != null) {
                this.totalNReference += (long)r.getNcount();
                ++this.totrefnumber;
                this.totrefsize += (long)r.getReadRecordLength();
                this.map.put(r.getName(), new ArrayList());
                this.setMean(r.getReadRecordLength());
                for (int i = 0; i < w; ++i) {
                    if (this.setseed) {
                        this.rand.setSeed((long)r.getReadRecordLength() + (long)i);
                    }
                    this.map.get(r.getName()).addAll(this.createContigsOnReference(r, frw, 1.0));
                }
                if (f == 0.0) continue;
                if (this.setseed) {
                    this.rand.setSeed((long)r.getReadRecordLength() - 1L);
                }
                this.map.get(r.getName()).addAll(this.createContigsOnReference(r, frw, f));
            }
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        catch (IllegalIntervalException ex) {
            ex.printStackTrace();
        }
        finally {
            frw.closeWriter();
        }
        this.report();
    }
}

