/*
 * Decompiled with CFR 0.152.
 */
package org.fda.contiggenerator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.fda.contiggenerator.ContigDetails;
import org.fda.data.Enums;
import org.fda.data.Utilities;
import org.fda.exceptions.IllegalIntervalException;
import org.fda.graphdrawing.data.CustomHistogramDataset;
import org.fda.inputdataparser.FastaReader;
import org.fda.inputdataparser.FastaRecord;
import org.fda.inputdataparser.FastaWriter;
import org.fda.intervaltree.Interval;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.statistics.HistogramType;

public abstract class ContigGenerator {
    protected final File infile;
    protected final File outfile;
    protected List<Integer> lengths = new ArrayList<Integer>();
    protected Map<String, List<Integer>> lengthsMap = new TreeMap<String, List<Integer>>();
    protected List<ContigDetails> finalcontigcoords = new ArrayList<ContigDetails>();
    protected int totcontnumber = 0;
    protected long totsize = 0L;
    protected long totrefsize = 0L;
    protected int totrefnumber = 0;
    protected long totalN = 0L;
    protected long totalNReference = 0L;
    protected boolean createreport = true;

    public ContigGenerator(File infile, File outfile) {
        this.infile = infile;
        this.outfile = outfile;
        File parent = outfile.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
    }

    public File getInfile() {
        return this.infile;
    }

    public File getOutfile() {
        return this.outfile;
    }

    public List<Integer> getLengths() {
        return this.lengths;
    }

    public List<ContigDetails> getFinalcontigcoords() {
        return this.finalcontigcoords;
    }

    public int getTotcontnumber() {
        return this.totcontnumber;
    }

    public long getTotsize() {
        return this.totsize;
    }

    public long getTotrefsize() {
        return this.totrefsize;
    }

    public int getTotrefnumber() {
        return this.totrefnumber;
    }

    public long getTotalN() {
        return this.totalN;
    }

    public long getTotalNReference() {
        return this.totalNReference;
    }

    public boolean isCreatereport() {
        return this.createreport;
    }

    public ContigGenerator(File infile, File outfile, boolean createreport) {
        this.infile = infile;
        this.outfile = outfile;
        File parent = outfile.getParentFile();
        this.createreport = createreport;
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
    }

    protected void report() {
        if (!this.createreport) {
            return;
        }
        File report = new File(this.outfile.getAbsolutePath() + ".report");
        File coordsReport = new File(this.outfile.getAbsolutePath() + ".coords");
        Collections.sort(this.lengths);
        NumberFormat nr = Utilities.numberFormatter;
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(report));
             BufferedWriter bwCoords = new BufferedWriter(new FileWriter(coordsReport));){
            if (!this.lengths.isEmpty()) {
                bwCoords.append("Contig Name\tCoords\tOrientation\tLength\tAmbiguousBaseCount(#N)\tAmbiguousBaseRatio(Nratio)" + Utilities.ls);
                bw.append("Total reference length (in bp): " + this.totrefsize + Utilities.ls);
                bw.append("Total ambiguious base size (N) in the reference: " + this.totalNReference + Utilities.ls);
                bw.append("Total number of reference sequences (chromosomes): " + this.totrefnumber + Utilities.ls);
                bw.append("Total number of contigs generated: " + this.totcontnumber + Utilities.ls);
                bw.append("Total contig length(bp): " + this.totsize + Utilities.ls);
                bw.append("Min contig length(bp): " + this.lengths.get(0) + Utilities.ls);
                bw.append("Max contig length(bp): " + this.lengths.get(this.lengths.size() - 1) + Utilities.ls);
                NumberFormat nm = Utilities.numberFormatter;
                double mean = (double)this.totsize / (double)this.totcontnumber;
                bw.append("Mean contig length(bp): " + nm.format(mean) + Utilities.ls);
                bw.append("Median contig length(bp): " + this.lengths.get(this.totcontnumber / 2) + Utilities.ls);
                bw.append("Total ambiguious base (N) size in contigs (bp): " + this.totalN + Utilities.ls);
                bw.append("========================================" + Utilities.ls);
                bw.append("Contig Length Distribution" + Utilities.ls);
                for (String s : this.lengthsMap.keySet()) {
                    List<Integer> smp = this.lengthsMap.get(s);
                    Collections.sort(smp);
                    bw.append(">" + s + Utilities.ls);
                    for (int k : smp) {
                        bw.append(k + Utilities.ls);
                    }
                }
                for (ContigDetails d : this.finalcontigcoords) {
                    bwCoords.append(d + Utilities.ls);
                }
                System.out.println("Contigs are generated and saved in " + this.outfile.getAbsolutePath());
                System.out.println("Report about the contigs' stats are saved in " + report.getAbsolutePath());
                System.out.println("The generated contigs' coordinates are saved in " + coordsReport.getAbsolutePath());
                this.drawLengthHistogram();
            } else {
                bw.append("No contigs generated!");
                bwCoords.append("No contigs generated!");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected void drawLengthHistogram() {
        double[] lengthlist = new double[this.lengths.size()];
        for (int i = 0; i < this.lengths.size(); ++i) {
            lengthlist[i] = this.lengths.get(i).intValue();
        }
        CustomHistogramDataset dataset = new CustomHistogramDataset();
        dataset.setType(HistogramType.FREQUENCY);
        dataset.addSeries((Comparable)((Object)"Length Frequency"), lengthlist, Utilities.no_hist_bins, lengthlist[0], lengthlist[this.lengths.size() - 1]);
        JFreeChart chart = ChartFactory.createHistogram("Contig Length Histogram ", null, null, dataset, PlotOrientation.VERTICAL, true, false, false);
        chart.getXYPlot().setForegroundAlpha(0.75f);
        File targetFile = new File(this.outfile.getAbsolutePath() + ".histogram" + Utilities.format.getExtension());
        Utilities.saveAsFile(chart, targetFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRefAsContigs() {
        FastaReader fr = new FastaReader();
        FastaWriter frw = new FastaWriter(this.outfile, true);
        try {
            FastaRecord r;
            fr.openFile(this.infile);
            while ((r = (FastaRecord)fr.readNextRecord()) != null) {
                frw.write(r);
                this.totsize += (long)r.getReadRecordLength();
                this.totalN += (long)r.getNcount();
                ++this.totcontnumber;
                ContigDetails tmp = new ContigDetails(r.getName(), r.getName(), new Interval(1, r.getReadRecordLength(), false), Enums.Orientation.F, r.getNcount(), r.getNratio());
                this.finalcontigcoords.add(tmp);
                this.add2Lengths(tmp);
            }
            fr.closeReader();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        catch (IllegalIntervalException ex) {
            ex.printStackTrace();
        }
        finally {
            frw.closeWriter();
        }
        this.report();
    }

    protected void add2Lengths(ContigDetails tmp) {
        this.lengths.add(tmp.getIr().getlength());
        if (this.lengthsMap.containsKey(tmp.getRefname())) {
            this.lengthsMap.get(tmp.getRefname()).add(tmp.getIr().getlength());
        } else {
            ArrayList<Integer> tlist = new ArrayList<Integer>();
            tlist.add(tmp.getIr().getlength());
            this.lengthsMap.put(tmp.getRefname(), tlist);
        }
    }
}

