/*
 * Decompiled with CFR 0.152.
 */
package org.fda.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.FileConverter;
import java.io.File;
import org.fda.commands.Command;
import org.fda.data.Enums;
import org.fda.data.Utilities;
import org.fda.functionality.AlphaValidator;
import org.fda.functionality.DistributionConverter;
import org.fda.functionality.PositiveReal;

@Parameters(commandDescription="Contig Generate command type 4. This command can generate contigs with three types of distributions: NORMAL, GAMMA and UNIFORM with the characteristics of these distributions and total desired coverage out of the given reference genome for the contigs are specified by the user.")
public class ContigGenerateCommand4
extends Command {
    @Parameter(names={"-f", "--infile"}, description="Input reference file path", required=true, converter=FileConverter.class)
    protected File inputFile;
    @Parameter(names={"-o", "--outfile"}, description="Output contig file path", required=false, converter=FileConverter.class)
    protected File outputFile = new File("contigs.fa");
    @Parameter(names={"-l", "--length distribution"}, description="Length distribution", required=true, converter=DistributionConverter.class)
    protected Enums.Distribution distribution;
    @Parameter(names={"-w", "--contigsoverlap"}, description="Generated contigs allowed to overlap or not? If this option is enabled, the program generates (possibly) overlapping, random contigs whose total lengths will be in the +-5% range of the given genome's 'total size x coverage'", required=false)
    protected boolean isRandom = false;
    @Parameter(names={"-x", "--coverage"}, description="Depth of coverage ", required=false, validateWith=PositiveReal.class)
    protected Double coverage = Utilities.depthCoverage;
    @Parameter(names={"-s"}, description="If -l is set to \"NORMAL\" then this represents the standard deviation of the Normal distribution, else if it is set to be \"GAMMA\", then this represents the shape of the Gamma distribution, else if it set to be \"UNIFORM\", then this parameter is not required at all, where these distributions correspond to the methodsused to generate contig lengths", required=false, validateWith=PositiveReal.class)
    protected Double contigSizeDev = 1.0;
    @Parameter(names={"-m"}, description="If -l is set to \"NORMAL\" then this represents the mean of the Normal distribution, else if it is set to be \"GAMMA\", then this represents the scale of the Gamma distribution, else if it set to be \"UNIFORM\", then this represents the maximum value for the distribution, where these distributions correspond to the methodsused to generate contig lengths", required=true, validateWith=PositiveReal.class)
    protected Double meanContigSize;
    @Parameter(names={"-g", "--nratio"}, description="The allowed percentage of the Ns in a contig", required=false, validateWith=AlphaValidator.class)
    protected final double nratio = Utilities.nratio;
    protected File destinationFolder = new File(System.getProperty("user.dir"));

    public Enums.Distribution getDistribution() {
        return this.distribution;
    }

    public boolean getIsRandom() {
        return this.isRandom;
    }

    public double getNratio() {
        return this.nratio;
    }

    public ContigGenerateCommand4() {
        this.rcmd = Enums.RunCommand.ContigGenerate4;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public double getCoverage() {
        return this.coverage;
    }

    public double getMeanContigSize() {
        return this.meanContigSize;
    }

    public double getContigSizeDev() {
        return this.contigSizeDev;
    }

    public File getDestinationFolder() {
        return this.destinationFolder;
    }
}

