/*
 * Decompiled with CFR 0.152.
 */
package org.fda.commands;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Field;
import java.util.Calendar;
import org.fda.data.Enums;
import org.fda.data.TimeKeeper;
import org.fda.data.Utilities;

public abstract class Command {
    public Enums.RunCommand rcmd;
    private final TimeKeeper tk = new TimeKeeper("CMD");
    private long beforeUsedMem;
    private long afterUsedMem;
    protected double actualUsedMemory;
    private Runtime rt = Runtime.getRuntime();

    public double getActualUsedMemory() {
        return this.actualUsedMemory;
    }

    public void startMemoryMeasurement() {
        this.beforeUsedMem = this.rt.totalMemory() - this.rt.freeMemory();
    }

    public void endMemoryMeasurement() {
        this.afterUsedMem = this.rt.totalMemory() - this.rt.freeMemory();
        this.actualUsedMemory = (double)(this.afterUsedMem - this.beforeUsedMem) / 1024.0 / 1024.0;
    }

    public boolean startTimer4Process(String label) {
        return this.tk.addStartTimePoint(label);
    }

    public boolean endTimer4Process(String label) {
        return this.tk.addEndTimePoint(label);
    }

    public boolean setCommandEnd() {
        return this.tk.stopTimer();
    }

    public void writeCommand() {
        this.setCommandEnd();
        Field[] fields = this.getClass().getDeclaredFields();
        try {
            Field destfield;
            Field cmdfield = this.getClass().getField("rcmd");
            try {
                destfield = this.getClass().getDeclaredField("destinationFolder");
                if ((File)destfield.get(this) == null) {
                    destfield = this.getClass().getDeclaredField("sourceFolder");
                }
            }
            catch (NoSuchFieldException nsfe) {
                destfield = this.getClass().getDeclaredField("sourceFolder");
            }
            destfield.setAccessible(true);
            String fname = ((File)destfield.get(this)).getAbsolutePath() + File.separator + cmdfield.get(this) + "_run_on_" + Calendar.getInstance().getTime().toString().replaceAll("\\s+|:", "_") + ".log";
            BufferedWriter bw = new BufferedWriter(new FileWriter(fname));
            bw.append("Command = " + cmdfield.get(this) + Utilities.ls);
            for (Field f : fields) {
                f.setAccessible(true);
                if (f.getType().getCanonicalName().equals(File.class.getCanonicalName())) {
                    if (f.get(this) != null) {
                        bw.append(f.getName() + " = " + ((File)f.get(this)).getAbsolutePath() + Utilities.ls);
                        continue;
                    }
                    bw.append(f.getName() + " = null" + Utilities.ls);
                    continue;
                }
                bw.append(f.getName() + " = " + f.get(this) + Utilities.ls);
            }
            bw.append(Utilities.ls);
            bw.append(this.tk.getPoints());
            bw.append("Memory Usage(in Mb):\t" + Utilities.numberFormatter.format(this.getActualUsedMemory()));
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeCommand(boolean writeLog2Dest) {
        this.setCommandEnd();
        Field[] fields = this.getClass().getDeclaredFields();
        try {
            Field cmdfield = this.getClass().getField("rcmd");
            Field destfield = writeLog2Dest ? this.getClass().getDeclaredField("destinationFolder") : this.getClass().getDeclaredField("sourceFolder");
            destfield.setAccessible(true);
            String fname = ((File)destfield.get(this)).getAbsolutePath() + File.separator + cmdfield.get(this) + "_run_on_" + Calendar.getInstance().getTime().toString().replaceAll("\\s+|:", "_") + ".log";
            BufferedWriter bw = new BufferedWriter(new FileWriter(fname));
            bw.append("dnAQET Version = " + Utilities.version + Utilities.ls);
            bw.append("Command = " + cmdfield.get(this) + Utilities.ls);
            for (Field f : fields) {
                f.setAccessible(true);
                if (f.getType().getCanonicalName().equals(File.class.getCanonicalName())) {
                    if (f.get(this) != null) {
                        bw.append(f.getName() + " = " + ((File)f.get(this)).getAbsolutePath() + Utilities.ls);
                        continue;
                    }
                    bw.append(f.getName() + " = null" + Utilities.ls);
                    continue;
                }
                bw.append(f.getName() + " = " + f.get(this) + Utilities.ls);
            }
            bw.append(Utilities.ls);
            bw.append(this.tk.getPoints());
            bw.append("Memory Usage(in Mb):\t" + Utilities.numberFormatter.format(this.getActualUsedMemory()));
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

