/*
 * Decompiled with CFR 0.152.
 */
package org.fda.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.FileConverter;
import com.beust.jcommander.validators.PositiveInteger;
import java.io.File;
import org.fda.commands.Command;
import org.fda.data.Enums;
import org.fda.data.Utilities;
import org.fda.functionality.AlignmentToolConverter;
import org.fda.functionality.AlphaValidator;
import org.fda.functionality.ScriptRunModeConverter;

@Parameters(commandDescription="Evaluate a de novo assembly by calculating a quality score and also assign quality scores to individual contigs/scaffolds with respect to a reference genome")
public class AlignEvalCommand
extends Command {
    @Parameter(names={"-d", "--evaldestfolder"}, description="Evaluation destination directory", required=false, converter=FileConverter.class)
    protected File destinationFolder = new File("RESULT");
    @Parameter(names={"-t", "--threadno"}, description="Number of threads", required=false, validateWith=PositiveInteger.class)
    protected int t = Utilities.no_threads;
    @Parameter(names={"-f", "--file"}, description="Input contig file", required=true, converter=FileConverter.class)
    protected File inputFile;
    @Parameter(names={"-n", "--npartition"}, description="Number of partitions for the input contig file", required=false, validateWith=PositiveInteger.class)
    protected int npart = 1;
    @Parameter(names={"-r", "--ref"}, description="A trusted reference genome file", required=true, converter=FileConverter.class)
    protected File refFile;
    @Parameter(names={"-k", "--model"}, description="A model file", required=false, converter=FileConverter.class)
    protected File modelFile;
    @Parameter(names={"-j", "--jobcommand"}, description="Alignment job submission command", required=false, converter=ScriptRunModeConverter.class)
    protected Enums.ScriptRunMode jobcommand = Utilities.submitJobs;
    @Parameter(names={"-p", "--jobcommandparams"}, description="Alignment job submission command parameters in quotes", required=false)
    protected String jobcommandparams = Utilities.submitJobsParameters;
    @Parameter(names={"-l", "--lengthscalingfactor"}, description="The length scaling factor constant that is used to scale the quality value of a scaffold/contig based on its size. The default value is the size of the smallest chromosome of the reference genome which is used to compute the regression model ", required=false, validateWith=PositiveInteger.class)
    private Integer lengthScalingFactor = null;
    @Parameter(names={"-m", "--ov_dist_threshold"}, description="Distance (or overlap) treshold for the alignments of consecutive parts of a contig to be considered a RELOCATION", required=false, validateWith=PositiveInteger.class)
    private int distThreshold = Utilities.alignmentDistanceThreshold;
    @Parameter(names={"-a", "--alpha"}, description="Alpha for reward", required=false, validateWith=AlphaValidator.class, hidden=true)
    private double alpha = Utilities.alpha;
    @Parameter(names={"-b", "--beta"}, description="Beta for penalty", required=false, validateWith=AlphaValidator.class, hidden=true)
    private double beta = Utilities.beta;
    @Parameter(names={"-q", "--alignmentTool"}, description="Tool used for the alignment of the contigs/scaffolds back to reference", required=false, converter=AlignmentToolConverter.class)
    private Enums.AlignmentTool alignmentTool = Utilities.alignmentTool;

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public Enums.AlignmentTool getAlignmentTool() {
        return this.alignmentTool;
    }

    public String getJobCommandParams() {
        return this.jobcommandparams;
    }

    public int threadNo() {
        return this.t;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public int getNumberPartitions() {
        return this.npart;
    }

    public File getDestinationFolder() {
        return this.destinationFolder;
    }

    public File getRefFile() {
        return this.refFile;
    }

    public Enums.ScriptRunMode getJobCommand() {
        return this.jobcommand;
    }

    public int getThreadNo() {
        return this.t;
    }

    public int getLengthScalingFactor() {
        if (this.lengthScalingFactor == null) {
            return 0;
        }
        return this.lengthScalingFactor;
    }

    public int getDistThreshold() {
        return this.distThreshold;
    }

    public AlignEvalCommand() {
        this.rcmd = Enums.RunCommand.AssemblyAlignAndEvaluate;
    }

    public File getEvalDestFolder() {
        return this.destinationFolder;
    }

    public File getModelFile() {
        return this.modelFile;
    }
}

