/*
 * Decompiled with CFR 0.152.
 */
package org.fda.checksum;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.fda.data.Utilities;

public class FileHashGenerator {
    public static byte[] generateMD5(String message) {
        return FileHashGenerator.hashString(message, "MD5");
    }

    public static byte[] generateSHA1(String message) {
        return FileHashGenerator.hashString(message, "SHA-1");
    }

    public static byte[] generateSHA256(String message) {
        return FileHashGenerator.hashString(message, "SHA-256");
    }

    public static byte[] generateMD5(File file) {
        return FileHashGenerator.hashFile(file, "MD5");
    }

    public static byte[] generateSHA1(File file) {
        return FileHashGenerator.hashFile(file, "SHA-1");
    }

    public static byte[] generateSHA256(File file) {
        return FileHashGenerator.hashFile(file, "SHA-256");
    }

    private static byte[] hashString(String message, String algorithm) {
        byte[] ret = null;
        try {
            byte[] hashedBytes;
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            ret = hashedBytes = digest.digest(message.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    private static byte[] hashFile(File file, String algorithm) {
        byte[] ret = null;
        try (FileInputStream inputStream = new FileInputStream(file);){
            byte[] hashedBytes;
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            byte[] bytesBuffer = new byte[1024];
            int bytesRead = -1;
            while ((bytesRead = inputStream.read(bytesBuffer)) != -1) {
                digest.update(bytesBuffer, 0, bytesRead);
            }
            ret = hashedBytes = digest.digest();
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            MessageDigest digest1 = MessageDigest.getInstance(Utilities.hashalg.toString());
            MessageDigest digest2 = MessageDigest.getInstance(Utilities.hashalg.toString());
            digest1.update("ABXA".getBytes("UTF-8"));
            digest1.update("B".getBytes("UTF-8"));
            digest1.update("A".getBytes("UTF-8"));
            digest1.update("BCAB".getBytes("UTF-8"));
            digest2.update("AB".getBytes("UTF-8"));
            digest2.update("XAB".getBytes("UTF-8"));
            digest2.update("AB".getBytes("UTF-8"));
            digest2.update("CAB".getBytes("UTF-8"));
            byte[] arr1 = digest1.digest();
            byte[] arr2 = digest2.digest();
            for (byte b : arr1) {
                System.out.print(b + " ");
            }
            System.out.println("");
            for (byte b : arr2) {
                System.out.print(b + " ");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

