/*
 * Decompiled with CFR 0.152.
 */
package org.fda.basicstats;

import java.io.Serializable;
import org.fda.intervaltree.IntervalSearchTree;

public class ContigRecord
implements Comparable<ContigRecord>,
Serializable {
    private final int length;
    private final int gc_count;
    private final String contigName;
    private final int n_count;
    private static final long serialVersionUID = -15925739L;
    private final byte[] hashValue;
    private final byte[] seqHashValue;
    private final IntervalSearchTree ist;

    public IntervalSearchTree getGapIntervals() {
        return this.ist;
    }

    public ContigRecord(String contigName, int length, int gc_count, int n_count, byte[] hashV, byte[] seqHashV, IntervalSearchTree ist) {
        this.contigName = contigName;
        this.length = length;
        this.gc_count = gc_count;
        this.n_count = n_count;
        this.hashValue = hashV;
        this.seqHashValue = seqHashV;
        this.ist = ist;
    }

    public byte[] getHashValue() {
        return this.hashValue;
    }

    public String getContigName() {
        return this.contigName;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getSeqHashValue() {
        return this.seqHashValue;
    }

    public int getGCCount() {
        return this.gc_count;
    }

    public int getNCount() {
        return this.n_count;
    }

    @Override
    public int compareTo(ContigRecord o) {
        return this.length - o.getLength();
    }
}

