/*
 * Decompiled with CFR 0.152.
 */
package org.fda.alignmentparser.paf;

import org.fda.alignmentparser.paf.Cigar;
import org.fda.alignmentparser.paf.TextCigarCodec;
import org.fda.data.Enums;
import org.fda.data.Reference;
import org.fda.data.ReferenceSet;

public class PafRecord {
    private final Reference reference;
    private final String contigID;
    private int contSt;
    private int contEnd;
    private int refSt;
    private int refEnd;
    private final Enums.Orientation orientation;
    private final int contigLength;
    private final int refSize;
    private final int qual;
    private Cigar cigar = null;

    public PafRecord(String s, ReferenceSet refset) {
        String[] arr = s.split("\t");
        this.contigID = arr[0];
        this.contigLength = Integer.parseInt(arr[1]);
        this.contSt = Integer.parseInt(arr[2]) + 1;
        this.contEnd = Integer.parseInt(arr[3]);
        this.orientation = arr[4].equals("+") ? Enums.Orientation.F : Enums.Orientation.R;
        this.reference = refset.findReference(arr[5]);
        this.refSize = Integer.parseInt(arr[6]);
        this.refSt = Integer.parseInt(arr[7]) + 1;
        this.refEnd = Integer.parseInt(arr[8]);
        this.qual = Integer.parseInt(arr[11]);
        String cigarstr = "*";
        for (int i = 12; i < arr.length; ++i) {
            if (!arr[i].startsWith("cg")) continue;
            cigarstr = arr[i].substring(5);
        }
        this.cigar = TextCigarCodec.decode(cigarstr);
    }

    public Reference getReference() {
        return this.reference;
    }

    public String getContigID() {
        return this.contigID;
    }

    public int getContSt() {
        return this.contSt;
    }

    public int getContEnd() {
        return this.contEnd;
    }

    public int getRefSt() {
        return this.refSt;
    }

    public int getRefEnd() {
        return this.refEnd;
    }

    public Enums.Orientation getOrientation() {
        return this.orientation;
    }

    public int getContigLength() {
        return this.contigLength;
    }

    public int getRefSize() {
        return this.refSize;
    }

    public int getQual() {
        return this.qual;
    }

    public Cigar getCigar() {
        return this.cigar;
    }

    public String toString() {
        StringBuilder br = new StringBuilder();
        br.append(this.getContigID() + "\t" + this.getReference().getRefID() + "\t" + this.getContSt() + "\t" + this.getContEnd() + "\t" + this.getRefSt() + "\t" + this.getRefEnd());
        return br.toString();
    }
}

