/*
 * Decompiled with CFR 0.152.
 */
package org.fda.alignmentparser.paf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.fda.alignmentparser.paf.PafRecord;
import org.fda.data.ReferenceSet;

public class PafFileReader {
    private BufferedReader br;
    private String header = null;
    private ReferenceSet chrset;
    private long recordnumber = 0L;

    public void openFile(File f, ReferenceSet c) throws FileNotFoundException, IOException {
        this.chrset = c;
        this.br = new BufferedReader(new FileReader(f));
    }

    public void closeReader() throws FileNotFoundException, IOException {
        this.br.close();
    }

    public PafRecord readNextPafRecord() {
        PafRecord pr = null;
        try {
            String line;
            while ((line = this.br.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                pr = new PafRecord(line, this.chrset);
                ++this.recordnumber;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pr;
    }
}

