/*
 * Decompiled with CFR 0.152.
 */
package org.fda.alignmentparser.delta;

import java.util.ArrayList;
import java.util.List;
import org.fda.alignment.Alignment;
import org.fda.alignment.NucmerAlignment;
import org.fda.data.Reference;
import org.fda.data.Utilities;
import org.fda.exceptions.IllegalIntervalException;

public class DeltaRecord {
    private final Reference refID;
    private final String contigID;
    private final String deltaRecString;
    private final int contigLength;
    private final int refChrLength;
    private final List<Alignment> alignments;

    public DeltaRecord(Reference refID, String contigID, String deltaRecString, int contLength, int refLength) {
        this.refID = refID;
        this.contigID = contigID;
        this.deltaRecString = deltaRecString;
        this.contigLength = contLength;
        this.refChrLength = refLength;
        this.alignments = this.setAlignmentsWDelta();
    }

    public List<Alignment> getAlignments() {
        return this.alignments;
    }

    public int getRefChrLength() {
        return this.refChrLength;
    }

    public int getContigLength() {
        return this.contigLength;
    }

    public Reference getRefID() {
        return this.refID;
    }

    public String getContigID() {
        return this.contigID;
    }

    public String getDeltaRecStr() {
        return this.deltaRecString;
    }

    private List<Alignment> setAlignmentsWDelta() {
        ArrayList<Alignment> al = new ArrayList<Alignment>();
        String[] arr = this.deltaRecString.split(Utilities.ls);
        int[] deltaArr = null;
        int i = 0;
        while (true) {
            int startPoint = ++i;
            while (!arr[i].equalsIgnoreCase("0")) {
                ++i;
            }
            int endPoint = i;
            if (endPoint >= startPoint) {
                String[] alDetails = arr[startPoint].split("\\s+");
                int total = Math.abs(Integer.parseInt(alDetails[0]) - Integer.parseInt(alDetails[1])) + 1;
                int idc = Integer.parseInt(alDetails[4]);
                int simc = Integer.parseInt(alDetails[5]);
                int stpc = Integer.parseInt(alDetails[6]);
                if (endPoint > ++startPoint) {
                    deltaArr = new int[endPoint - startPoint];
                    int tmpInd = 0;
                    for (int j = startPoint; j < endPoint; ++j) {
                        deltaArr[tmpInd] = Integer.parseInt(arr[j]);
                        ++total;
                        ++tmpInd;
                    }
                } else {
                    deltaArr = null;
                }
                double id = (double)(total - idc) / (double)total * 100.0;
                double sim = (double)(total - simc) / (double)total * 100.0;
                double stp = (double)stpc / (double)(total * 2) * 100.0;
                try {
                    al.add(new NucmerAlignment(this.refID, Integer.parseInt(alDetails[0]), Integer.parseInt(alDetails[1]), Integer.parseInt(alDetails[2]), Integer.parseInt(alDetails[3]), idc, simc, stpc, id, sim, stp, deltaArr));
                }
                catch (IllegalIntervalException illegalIntervalException) {
                    // empty catch block
                }
            }
            if (i >= arr.length - 1) break;
        }
        return al;
    }
}

