/*
 * Decompiled with CFR 0.152.
 */
package org.fda.alignmentparser.delta;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.fda.alignment.ScaffoldContig;
import org.fda.alignmentparser.AlignmentReaderRunnable;
import org.fda.alignmentparser.delta.DeltaFileReader;
import org.fda.alignmentparser.delta.DeltaRecord;
import org.fda.basicstats.ContigRecord;
import org.fda.data.ReferenceSet;

public class DeltaReaderRunnable
extends AlignmentReaderRunnable {
    private final DeltaFileReader dfr = new DeltaFileReader();
    private final File sourceFolder;

    public DeltaReaderRunnable(BlockingQueue inqueue, BlockingQueue outqueue, ReferenceSet ch, int no, File sourceFolder) {
        super(inqueue, outqueue, ch, no);
        this.sourceFolder = sourceFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(List<File> filelist) {
        HashSet<String> asc = new HashSet<String>();
        HashMap<String, ScaffoldContig> alignmentCollection = new HashMap<String, ScaffoldContig>();
        Map contigs = null;
        ObjectInputStream input = null;
        try {
            input = new ObjectInputStream(new BufferedInputStream(new FileInputStream(new File(this.sourceFolder.getAbsolutePath() + File.separator + "contigRecords.bin"))));
            contigs = (Map)input.readObject();
            for (File f : filelist) {
                DeltaRecord dr;
                this.dfr.openFile(f, this.chrset);
                while ((dr = this.dfr.readNextDeltaRecord()) != null) {
                    asc.add(dr.getContigID());
                    if (alignmentCollection.containsKey(dr.getContigID())) {
                        ((ScaffoldContig)alignmentCollection.get(dr.getContigID())).addAlignments(dr.getAlignments());
                        continue;
                    }
                    ScaffoldContig as = new ScaffoldContig(dr.getContigID(), dr.getContigLength());
                    as.addAlignments(dr.getAlignments());
                    as.setHashValue(((ContigRecord)contigs.get(dr.getContigID())).getHashValue());
                    as.setSeqHashValue(((ContigRecord)contigs.get(dr.getContigID())).getSeqHashValue());
                    as.setGCCount(((ContigRecord)contigs.get(dr.getContigID())).getGCCount());
                    as.setGapIntervalTree(((ContigRecord)contigs.get(dr.getContigID())).getGapIntervals());
                    as.setNCount(((ContigRecord)contigs.get(dr.getContigID())).getNCount());
                    alignmentCollection.put(dr.getContigID(), as);
                }
                this.dfr.closeReader();
            }
            for (String contID : asc) {
                this.outqueue.put(alignmentCollection.get(contID));
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException ex) {
            if (!(ex instanceof EOFException)) {
                ex.printStackTrace();
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                input.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

