/*
 * Decompiled with CFR 0.152.
 */
package org.fda.alignment;

import org.fda.alignment.Alignment;
import org.fda.data.Enums;
import org.fda.data.Reference;
import org.fda.data.Utilities;
import org.fda.exceptions.IllegalIntervalException;

public class NucmerAlignment
extends Alignment {
    private int[] deltas;
    private double sim;
    private double stp;
    private int simc;
    private int idc;
    private int stpc;
    private static final long serialVersionUID = -159257338189L;

    public NucmerAlignment(Reference refID, int s_Ref, int e_Ref, int s_Cont, int e_Cont, int idc, int simc, int stpc, double id, double sim, double stp, int[] deltas) throws IllegalIntervalException {
        super(refID, s_Ref, e_Ref, s_Cont, e_Cont, id);
        this.deltas = deltas;
        this.simc = simc;
        this.stpc = stpc;
        this.idc = idc;
        this.stp = stp;
        this.sim = sim;
    }

    public void resetDelta() {
        this.deltas = null;
    }

    public int[] getDelta() {
        return this.deltas;
    }

    @Override
    public void setContEnd(int e_Cont) throws IllegalIntervalException {
        if (e_Cont > this.contigInterval.gethigh()) {
            throw new RuntimeException("New end coordinate for this alignment exceeds the old end coordinate" + Utilities.ls + "Coordinates can only be shrunk!");
        }
        if (this.deltas == null) {
            super.setContEnd(e_Cont);
            return;
        }
        int[] newDelta = null;
        this.endTrimmed = true;
        if (this.contigOr == Enums.Orientation.F) {
            int i;
            int indC = this.contigInterval.getlow() - 1;
            int indR = this.referenceInterval.getlow() - 1;
            for (i = 0; i < this.deltas.length; ++i) {
                int displacement;
                int prevC = indC;
                int prevR = indR;
                int currdelta = Math.abs(this.deltas[i]);
                if (this.deltas[i] < 0) {
                    indR = indR + currdelta - 1;
                    if ((indC += currdelta) == e_Cont) {
                        this.referenceInterval.sethigh(indR);
                        newDelta = new int[i + 1];
                        newDelta[i] = this.deltas[i];
                        break;
                    }
                    if (indC <= e_Cont) continue;
                    displacement = e_Cont - prevC;
                    this.referenceInterval.sethigh(prevR + displacement);
                    newDelta = new int[i];
                    break;
                }
                indC = indC + currdelta - 1;
                indR += currdelta;
                if (indC == e_Cont) {
                    this.referenceInterval.sethigh(indR - 1);
                    newDelta = new int[i];
                    break;
                }
                if (indC <= e_Cont) continue;
                displacement = e_Cont - prevC;
                this.referenceInterval.sethigh(prevR + displacement);
                newDelta = new int[i];
                break;
            }
            --i;
            if (newDelta != null) {
                for (int k = i; k >= 0; --k) {
                    newDelta[k] = this.deltas[k];
                }
                this.deltas = newDelta;
            } else {
                this.referenceInterval.sethigh(indR + (e_Cont - indC));
            }
        } else {
            int i;
            int indC = this.contigInterval.gethigh() + 1;
            int indR = this.referenceInterval.getlow() - 1;
            for (i = 0; i < this.deltas.length; ++i) {
                int displacement;
                int prevC = indC;
                int prevR = indR;
                int currdelta = Math.abs(this.deltas[i]);
                if (this.deltas[i] < 0) {
                    indR = indR + currdelta - 1;
                    if ((indC -= currdelta) == e_Cont) {
                        this.referenceInterval.setlow(indR + 1);
                        newDelta = new int[this.deltas.length - i];
                        newDelta[0] = -1;
                        break;
                    }
                    if (indC >= e_Cont) continue;
                    displacement = prevC - e_Cont;
                    this.referenceInterval.setlow(prevR + displacement);
                    newDelta = new int[this.deltas.length - i];
                    newDelta[0] = -(e_Cont - indC + 1);
                    break;
                }
                indC = indC - currdelta + 1;
                indR += currdelta;
                if (indC == e_Cont) {
                    this.referenceInterval.setlow(indR - 1);
                    newDelta = new int[this.deltas.length - i];
                    newDelta[0] = 2;
                    break;
                }
                if (indC >= e_Cont) continue;
                displacement = prevC - e_Cont;
                this.referenceInterval.setlow(prevR + displacement);
                newDelta = new int[this.deltas.length - i];
                newDelta[0] = indR - this.referenceInterval.getlow() + 1;
                break;
            }
            ++i;
            if (newDelta != null) {
                int k = 1;
                while (k < newDelta.length) {
                    newDelta[k] = this.deltas[i];
                    ++k;
                    ++i;
                }
                this.deltas = newDelta;
            } else {
                this.referenceInterval.setlow(indR + (indC - e_Cont));
                this.deltas = new int[0];
            }
        }
        this.contigInterval.sethigh(e_Cont);
    }

    @Override
    public void setContSt(int s_Cont) throws IllegalIntervalException {
        if (s_Cont < this.contigInterval.getlow()) {
            throw new RuntimeException("New start coordinate for this alignment is smaller than the old start coordinate" + Utilities.ls + "Coordinates can only be shrunk!");
        }
        if (this.deltas == null) {
            super.setContSt(s_Cont);
            return;
        }
        this.startTrimmed = true;
        int[] newDelta = null;
        if (this.contigOr == Enums.Orientation.F) {
            int i;
            int indC = this.contigInterval.getlow() - 1;
            int indR = this.referenceInterval.getlow() - 1;
            for (i = 0; i < this.deltas.length; ++i) {
                int displacement;
                int prevC = indC;
                int prevR = indR;
                int currdelta = Math.abs(this.deltas[i]);
                if (this.deltas[i] < 0) {
                    indR = indR + currdelta - 1;
                    if ((indC += currdelta) == s_Cont) {
                        this.referenceInterval.setlow(indR + 1);
                        newDelta = new int[this.deltas.length - i];
                        newDelta[0] = -1;
                        break;
                    }
                    if (indC <= s_Cont) continue;
                    displacement = s_Cont - prevC;
                    this.referenceInterval.setlow(prevR + displacement);
                    newDelta = new int[this.deltas.length - i];
                    newDelta[0] = -(indC - s_Cont + 1);
                    break;
                }
                indC = indC + currdelta - 1;
                indR += currdelta;
                if (indC == s_Cont) {
                    this.referenceInterval.setlow(indR - 1);
                    newDelta = new int[this.deltas.length - i];
                    newDelta[0] = indR - this.referenceInterval.getlow() + 1;
                    break;
                }
                if (indC <= s_Cont) continue;
                displacement = s_Cont - prevC;
                this.referenceInterval.setlow(prevR + displacement);
                newDelta = new int[this.deltas.length - i];
                newDelta[0] = indC - s_Cont + 1;
                break;
            }
            ++i;
            if (newDelta != null) {
                int k = 1;
                while (k < newDelta.length) {
                    newDelta[k] = this.deltas[i];
                    ++k;
                    ++i;
                }
                this.deltas = newDelta;
            } else {
                this.referenceInterval.setlow(this.referenceInterval.gethigh() - (this.contigInterval.gethigh() - s_Cont));
                this.deltas = new int[0];
            }
        } else {
            int i;
            int indC = this.contigInterval.gethigh() + 1;
            int indR = this.referenceInterval.getlow() - 1;
            for (i = 0; i < this.deltas.length; ++i) {
                int displacement;
                int prevC = indC;
                int prevR = indR;
                int currdelta = Math.abs(this.deltas[i]);
                if (this.deltas[i] < 0) {
                    indR = indR + currdelta - 1;
                    if ((indC -= currdelta) == s_Cont) {
                        this.referenceInterval.sethigh(indR);
                        newDelta = new int[i + 1];
                        newDelta[i] = -(indR - prevR + 1);
                        break;
                    }
                    if (indC >= s_Cont) continue;
                    displacement = prevC - s_Cont;
                    this.referenceInterval.sethigh(prevR + displacement);
                    newDelta = new int[i];
                    break;
                }
                indC = indC - currdelta + 1;
                indR += currdelta;
                if (indC == s_Cont) {
                    this.referenceInterval.sethigh(indR - 1);
                    newDelta = new int[i];
                    break;
                }
                if (indC >= s_Cont) continue;
                displacement = prevC - s_Cont;
                this.referenceInterval.sethigh(prevR + displacement);
                newDelta = new int[i];
                break;
            }
            --i;
            if (newDelta != null) {
                for (int k = 0; k <= i; ++k) {
                    newDelta[k] = this.deltas[k];
                }
                this.deltas = newDelta;
            } else {
                this.referenceInterval.sethigh(indR + (indC - s_Cont));
            }
        }
        this.contigInterval.setlow(s_Cont);
    }

    public String getDeltaRepresentation() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.refOr == Enums.Orientation.F ? this.referenceInterval.getlow() + " " + this.referenceInterval.gethigh() + " " : this.referenceInterval.gethigh() + " " + this.referenceInterval.getlow() + " ");
        sb.append(this.contigOr == Enums.Orientation.F ? this.contigInterval.getlow() + " " + this.contigInterval.gethigh() + " " : this.contigInterval.gethigh() + " " + this.contigInterval.getlow() + " ");
        sb.append(this.idc).append(" ").append(this.simc).append(" ").append(this.stpc).append(Utilities.ls);
        if (this.deltas != null) {
            for (int i : this.deltas) {
                sb.append(i).append(Utilities.ls);
            }
        }
        sb.append("0").append(Utilities.ls);
        return sb.toString();
    }
}

