/*
 * Decompiled with CFR 0.152.
 */
package org.fda.alignment;

import org.fda.alignment.Alignment;
import org.fda.data.Utilities;

public class AlignmentWrapper
implements Comparable<AlignmentWrapper> {
    private Alignment alignment = null;
    private long score = 0L;
    private long diff = 0L;
    private int from = -1;
    private boolean used = false;

    AlignmentWrapper(Alignment alignment) {
        this.alignment = alignment;
    }

    public void setScore(long score) {
        this.score = score;
    }

    public void setDiff(long diff) {
        this.diff = diff;
    }

    public void setFrom(int from) {
        this.from = from;
    }

    public void setUsed(boolean used) {
        this.used = used;
    }

    public Alignment getAlign() {
        return this.alignment;
    }

    public long getScore() {
        return this.score;
    }

    public long getDiff() {
        return this.diff;
    }

    public int getFrom() {
        return this.from;
    }

    public boolean getUsed() {
        return this.used;
    }

    @Override
    public int compareTo(AlignmentWrapper o) {
        long b;
        if (this.getAlign().getContSt() < o.getAlign().getContSt()) {
            return -1;
        }
        if (this.getAlign().getContSt() > o.getAlign().getContSt()) {
            return 1;
        }
        long a = Utilities.scoreLocal(0L, this.getAlign().getContigAlignmentLength(), 0, 0, this.getAlign().getIdentity(), 0.0);
        if (a == (b = Utilities.scoreLocal(0L, o.getAlign().getContigAlignmentLength(), 0, 0, o.getAlign().getIdentity(), 0.0))) {
            return 0;
        }
        if (a > b) {
            return -1;
        }
        return 1;
    }
}

