/*
 * Decompiled with CFR 0.152.
 */
package org.fda.alignment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.fda.alignment.Alignment;
import org.fda.alignment.AlignmentFilter;
import org.fda.alignment.AlignmentWrapper;
import org.fda.alignment.ScaffoldContig;
import org.fda.basicstats.BasicStatsComputeFromList;
import org.fda.data.Utilities;

public class AlignmentFilterQ
extends AlignmentFilter {
    public AlignmentFilterQ(BlockingQueue queue, int no, BlockingQueue oqueue) {
        super(queue, oqueue);
        this.id = "ContigFilter" + no;
    }

    public AlignmentFilterQ(BlockingQueue queue, int no, BlockingQueue oqueue, BasicStatsComputeFromList bsc) {
        super(queue, oqueue, bsc);
        this.id = "ContigFilter" + no;
    }

    private List<Alignment> filterU(ScaffoldContig as) {
        int i;
        AlignmentWrapper[] lis = this.createAlignmentWrappers(as.getAlignments()).toArray(new AlignmentWrapper[0]);
        int n = lis.length;
        ArrayList<Integer> allbest = new ArrayList<Integer>();
        do {
            for (i = 0; i < n; ++i) {
                if (lis[i].getUsed()) continue;
                int leni = lis[i].getAlign().getContigAlignmentLength();
                lis[i].setScore(Utilities.scoreLocal(0L, leni, 0, 0, lis[i].getAlign().getIdentity(), 0.0));
                lis[i].setFrom(-1);
                lis[i].setDiff(0L);
                for (int j = 0; j < i; ++j) {
                    if (lis[j].getUsed() || lis[j].getFrom() >= 0 && lis[lis[j].getFrom()].getAlign().getContEnd() >= lis[i].getAlign().getContSt()) continue;
                    int lenj = lis[j].getAlign().getContigAlignmentLength();
                    int olap = lis[j].getAlign().overlapContig(lis[i].getAlign());
                    if (olap < 0) {
                        olap = 0;
                    }
                    long diff = lis[j].getDiff() + (long)this.diffAligns(lis[i].getAlign(), lis[j].getAlign());
                    long score = Utilities.scoreLocal(lis[j].getScore(), leni, lenj, olap, lis[i].getAlign().getIdentity(), 90.0);
                    if (score <= lis[i].getScore() && (score != lis[i].getScore() || diff >= lis[i].getDiff()) && (score != lis[i].getScore() || diff != lis[i].getDiff() || !Arrays.equals(lis[j].getAlign().getReference().getSeqHashValue(), as.getSeqHashValue()))) continue;
                    lis[i].setFrom(j);
                    lis[i].setScore(score);
                    lis[i].setDiff(diff);
                }
            }
        } while (this.updateBest(lis, n, allbest, -1.0));
        int beg = 0;
        int end = allbest.size();
        if (beg == end) {
            beg = 0;
        } else {
            end = beg + 1;
        }
        ArrayList<Alignment> a2ret = new ArrayList<Alignment>();
        while (beg < end) {
            i = (Integer)allbest.get(beg);
            while (i >= 0 && i < n) {
                a2ret.add(lis[i].getAlign());
                i = lis[i].getFrom();
            }
            ++beg;
        }
        return a2ret;
    }

    @Override
    public void filter(ScaffoldContig as) {
        List<Alignment> a2ret = this.filterU(as);
        this.setAlignments(as, a2ret);
    }
}

