/*
 * Decompiled with CFR 0.152.
 */
package org.fda.alignment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.fda.alignment.Alignment;
import org.fda.alignment.AlignmentFilter;
import org.fda.alignment.AlignmentWrapper;
import org.fda.alignment.ScaffoldContig;
import org.fda.basicstats.BasicStatsComputeFromList;
import org.fda.data.Reference;
import org.fda.data.Utilities;

public class AlignmentFilterG
extends AlignmentFilter {
    public AlignmentFilterG(BlockingQueue queue, int no, BlockingQueue oqueue) {
        super(queue, oqueue);
        this.id = "GlobalFilter" + no;
    }

    public AlignmentFilterG(BlockingQueue queue, int no, BlockingQueue oqueue, BasicStatsComputeFromList bsc) {
        super(queue, oqueue, bsc);
        this.id = "GlobalFilter" + no;
    }

    private int RevC(int coord, int len) {
        return len - coord + 1;
    }

    private double score(List<Alignment> alignments) {
        double sum = 0.0;
        for (Alignment a : alignments) {
            sum += a.getIdentity() * (double)a.getRefAlignmentLength();
        }
        return sum;
    }

    @Override
    public void filter(ScaffoldContig as) {
        List<Alignment> a2ret = new ArrayList<Alignment>();
        double best = 0.0;
        for (Reference c : as.getReferences()) {
            List<Alignment> tmp = this.filterU(as, c);
            double curr = this.score(tmp);
            if (!(curr > best)) continue;
            a2ret = tmp;
            best = curr;
        }
        this.setAlignments(as, a2ret);
    }

    private List<Alignment> filterU(ScaffoldContig as, Reference c) {
        int i;
        AlignmentWrapper[] lis = this.createAlignmentWrappers(as.getAlignments(c)).toArray(new AlignmentWrapper[0]);
        int n = lis.length;
        ArrayList<Integer> allbest = new ArrayList<Integer>();
        do {
            for (i = 0; i < n; ++i) {
                int lenQ;
                if (lis[i].getUsed()) continue;
                int lenR = lis[i].getAlign().getRefAlignmentLength();
                int len = lenR > (lenQ = lis[i].getAlign().getContigAlignmentLength()) ? lenQ : lenR;
                lis[i].setScore(Utilities.scoreGlobal(0L, len, 0L, lis[i].getAlign().getIdentity()));
                lis[i].setFrom(-1);
                lis[i].setDiff(0L);
                for (int j = 0; j < i; ++j) {
                    int olap;
                    if (lis[j].getUsed() || lis[i].getAlign().getContigOrientation() != lis[j].getAlign().getContigOrientation()) continue;
                    int olapQ = lis[j].getAlign().overlapContig(lis[i].getAlign());
                    int olapR = lis[j].getAlign().overlapRef(lis[i].getAlign());
                    int n2 = olap = olapR > olapQ ? olapR : olapQ;
                    if (olap < 0) {
                        olap = 0;
                    }
                    long diff = lis[j].getDiff() + (long)this.diffAligns(lis[i].getAlign(), lis[j].getAlign());
                    long score = Utilities.scoreGlobal2(lis[j].getScore(), lenR, lenQ, lis[j].getAlign().getRefAlignmentLength(), lis[j].getAlign().getContigAlignmentLength(), olapR, olapQ, lis[i].getAlign().getIdentity(), 90.0);
                    if (score <= lis[i].getScore() && (score != lis[i].getScore() || diff >= lis[i].getDiff()) && (score != lis[i].getScore() || diff != lis[i].getDiff() || !Arrays.equals(lis[j].getAlign().getReference().getSeqHashValue(), as.getSeqHashValue()))) continue;
                    lis[i].setFrom(j);
                    lis[i].setScore(score);
                    lis[i].setDiff(diff);
                }
            }
        } while (this.updateBest(lis, n, allbest, -1.0));
        int beg = 0;
        int end = allbest.size();
        if (beg == end) {
            beg = 0;
        } else {
            end = beg + 1;
        }
        ArrayList<Alignment> a2ret = new ArrayList<Alignment>();
        while (beg < end) {
            i = (Integer)allbest.get(beg);
            while (i >= 0 && i < n) {
                a2ret.add(lis[i].getAlign());
                i = lis[i].getFrom();
            }
            ++beg;
        }
        return a2ret;
    }
}

