/*
 * Decompiled with CFR 0.152.
 */
package org.fda.alignment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import org.fda.alignment.Alignment;
import org.fda.alignment.AlignmentWrapper;
import org.fda.alignment.NucmerAlignment;
import org.fda.alignment.ScaffoldContig;
import org.fda.basicstats.BasicStatsComputeFromList;
import org.fda.data.Utilities;
import org.fda.exceptions.IllegalIntervalException;

public abstract class AlignmentFilter
implements Runnable {
    private BlockingQueue inQueue = null;
    private BlockingQueue outQueue = null;
    protected String id = "AbstractFilter";
    private BasicStatsComputeFromList bsc = null;

    public AlignmentFilter(BlockingQueue queue, BlockingQueue oqueue) {
        this.inQueue = queue;
        this.outQueue = oqueue;
    }

    public AlignmentFilter(BlockingQueue queue, BlockingQueue oqueue, BasicStatsComputeFromList bsc) {
        this.inQueue = queue;
        this.outQueue = oqueue;
        this.bsc = bsc;
    }

    protected int diffAligns(Alignment i, Alignment j) {
        return (j.getRefSt() < i.getRefSt() ? Math.abs(j.getRefEnd() - i.getRefSt()) : Math.abs(i.getRefEnd() - j.getRefSt())) + (j.getContSt() < j.getContSt() ? Math.abs(j.getContEnd() - i.getContSt()) : Math.abs(i.getContEnd() - j.getContSt()));
    }

    protected boolean updateBest(AlignmentWrapper[] lis, long size, List<Integer> allbest, double epsilon) {
        if (size == 0L) {
            return false;
        }
        int best = 0;
        while ((long)best < size && lis[best].getUsed()) {
            ++best;
        }
        int i = best + 1;
        while ((long)i < size) {
            if (!lis[i].getUsed() && (lis[i].getScore() > lis[best].getScore() || lis[i].getScore() == lis[best].getScore() && lis[i].getDiff() < lis[best].getDiff())) {
                best = i;
            }
            ++i;
        }
        if (!allbest.isEmpty() && ((long)best == size || epsilon < 0.0 && lis[best].getScore() < lis[allbest.get(0)].getScore() || epsilon >= 0.0 && (double)(lis[allbest.get(0)].getScore() - lis[best].getScore()) / (double)lis[allbest.get(0)].getScore() * 100.0 > epsilon)) {
            return false;
        }
        allbest.add(best);
        i = best;
        while (i >= 0 && (long)i < size) {
            lis[i].setUsed(true);
            i = lis[i].getFrom();
        }
        return true;
    }

    protected int pickBest(AlignmentWrapper[] lis, List<Integer> allbest, double epsilon) {
        int RAND_MAX = Short.MAX_VALUE;
        int size = allbest.size();
        Random r = new Random();
        if (epsilon < 0.0 && size != 0) {
            int eqc;
            for (eqc = 0; eqc < size && lis[allbest.get(eqc)].getDiff() == lis[allbest.get(0)].getDiff(); ++eqc) {
            }
            return (int)((double)eqc * (double)r.nextInt(RAND_MAX) / ((double)RAND_MAX + 1.0));
        }
        return size;
    }

    protected List<AlignmentWrapper> createAlignmentWrappers(List<Alignment> as) {
        ArrayList<AlignmentWrapper> aw = new ArrayList<AlignmentWrapper>();
        for (int i = 0; i < as.size(); ++i) {
            if (!(100.0 * as.get(i).getIdentity() >= (double)Utilities.alignmentIdentityThreshold) || as.get(i).getContigAlignmentLength() < 0 || as.get(i).getRefAlignmentLength() < 0) continue;
            aw.add(new AlignmentWrapper(as.get(i)));
        }
        Collections.sort(aw);
        return aw;
    }

    public abstract void filter(ScaffoldContig var1);

    protected void setAlignments(ScaffoldContig as, List<Alignment> a2ret) {
        boolean put = true;
        if (a2ret.isEmpty()) {
            put = false;
        } else if (a2ret.size() == 1) {
            as.setCoverage(a2ret.get(0).getContigAlignmentLength(), a2ret.get(0).getRefAlignmentLength());
            as.setAlignments(a2ret);
        } else {
            Collections.reverse(a2ret);
            int csor = 0;
            int asoc = 0;
            ArrayList<Integer> toremove = new ArrayList<Integer>();
            int i = 0;
            while (i < a2ret.size() - 1) {
                Alignment b;
                Alignment a = a2ret.get(i);
                int ov = a.overlapContig(b = a2ret.get(i + 1));
                if (ov == 0) {
                    asoc += a.getContigAlignmentLength();
                    csor += a.getRefAlignmentLength();
                    ++i;
                    continue;
                }
                if (ov == a.getContigAlignmentLength()) {
                    toremove.add(i);
                    ++i;
                    continue;
                }
                if (ov == b.getContigAlignmentLength()) {
                    toremove.add(i + 1);
                    i += 2;
                    asoc += a.getContigAlignmentLength();
                    csor += a.getRefAlignmentLength();
                    continue;
                }
                if ((double)ov / (double)a.getContigAlignmentLength() < (double)ov / (double)b.getContigAlignmentLength()) {
                    try {
                        b.setContSt(a.getContEnd() + 1);
                    }
                    catch (IllegalIntervalException ex) {
                        toremove.add(i + 1);
                        i += 2;
                    }
                } else {
                    try {
                        a.setContEnd(b.getContSt() - 1);
                    }
                    catch (IllegalIntervalException ex) {
                        toremove.add(i);
                        ++i;
                    }
                }
                asoc += a.getContigAlignmentLength();
                csor += a.getRefAlignmentLength();
                ++i;
            }
            Collections.sort(toremove);
            for (i = toremove.size() - 1; i >= 0; --i) {
                a2ret.remove((Integer)toremove.get(i));
            }
            asoc += a2ret.get(a2ret.size() - 1).getContigAlignmentLength();
            csor += a2ret.get(a2ret.size() - 1).getRefAlignmentLength();
            as.setAlignments(a2ret);
            if (Utilities.assignQuality) {
                as.setCoverage(asoc, csor);
            }
        }
        try {
            if (put) {
                if (Utilities.assignQuality) {
                    as.assignQuality();
                } else {
                    as.setMisassembly();
                }
                this.outQueue.put(as);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void resetDeltas(List<Alignment> a2ret) {
        for (Alignment a : a2ret) {
            this.resetDelta(a);
        }
    }

    private void resetDelta(Alignment alignment) {
        if (alignment instanceof NucmerAlignment) {
            ((NucmerAlignment)alignment).resetDelta();
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                Object as;
                while ((as = this.inQueue.take()) instanceof ScaffoldContig) {
                    this.filter((ScaffoldContig)as);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }
}

