/*
 * Decompiled with CFR 0.152.
 */
package org.fda.alignment;

import java.io.Serializable;
import java.text.NumberFormat;
import org.fda.data.Enums;
import org.fda.data.Reference;
import org.fda.data.Utilities;
import org.fda.exceptions.IllegalIntervalException;
import org.fda.intervaltree.Interval;

public class Alignment
implements Comparable<Alignment>,
Serializable {
    protected final Reference reference;
    protected Interval contigInterval;
    protected Interval referenceInterval;
    protected double id;
    protected Enums.Orientation refOr;
    protected Enums.Orientation contigOr;
    protected boolean startTrimmed;
    protected boolean endTrimmed;
    private static final long serialVersionUID = 112414357102382689L;

    public Alignment(Reference refID, int s_Ref, int e_Ref, int s_Cont, int e_Cont, double id) throws IllegalIntervalException {
        this.reference = refID;
        this.id = id / 100.0;
        this.refOr = s_Ref <= e_Ref ? Enums.Orientation.F : Enums.Orientation.R;
        this.contigOr = s_Cont <= e_Cont ? Enums.Orientation.F : Enums.Orientation.R;
        this.startTrimmed = false;
        this.endTrimmed = false;
        this.referenceInterval = new Interval(this.refOr == Enums.Orientation.F ? s_Ref : e_Ref, this.refOr == Enums.Orientation.F ? e_Ref : s_Ref, false);
        this.contigInterval = new Interval(this.contigOr == Enums.Orientation.F ? s_Cont : e_Cont, this.contigOr == Enums.Orientation.F ? e_Cont : s_Cont, false);
    }

    public boolean getStTrimmed() {
        return this.startTrimmed;
    }

    public boolean getEndTrimmed() {
        return this.endTrimmed;
    }

    public Enums.Orientation getRefOrientation() {
        return this.refOr;
    }

    public Enums.Orientation getContigOrientation() {
        return this.contigOr;
    }

    public void setRefOrientation(Enums.Orientation o) {
        this.refOr = o;
    }

    public void setContigOrientation(Enums.Orientation o) {
        this.contigOr = o;
    }

    private void setRefSt(int s_Ref) throws IllegalIntervalException {
        this.referenceInterval.setlow(s_Ref);
    }

    private void setRefEnd(int e_Ref) throws IllegalIntervalException {
        this.referenceInterval.sethigh(e_Ref);
    }

    public void swapStartEndOnContig() throws IllegalIntervalException {
        int lo = this.contigInterval.getlow();
        this.contigInterval.setlow(this.contigInterval.gethigh());
        this.contigInterval.sethigh(lo);
    }

    public void _setContSt(int st) throws IllegalIntervalException {
        this.contigInterval.setlow(st);
    }

    public void _setContEnd(int end) throws IllegalIntervalException {
        this.contigInterval.sethigh(end);
    }

    public void setContEnd(int e_Cont) throws IllegalIntervalException {
        this.endTrimmed = true;
        int displacement = e_Cont - this.contigInterval.gethigh();
        this.contigInterval.sethigh(e_Cont);
        if (this.contigOr == Enums.Orientation.F) {
            this.referenceInterval.sethigh(this.referenceInterval.gethigh() + displacement);
        } else {
            this.referenceInterval.setlow(this.referenceInterval.getlow() - displacement);
        }
    }

    public void setContSt(int s_Cont) throws IllegalIntervalException {
        this.startTrimmed = true;
        int displacement = s_Cont - this.contigInterval.getlow();
        this.contigInterval.setlow(s_Cont);
        if (this.contigOr == Enums.Orientation.F) {
            this.referenceInterval.setlow(this.referenceInterval.getlow() + displacement);
        } else {
            this.referenceInterval.sethigh(this.referenceInterval.gethigh() - displacement);
        }
    }

    public int getRefSt() {
        return this.referenceInterval.getlow();
    }

    public int getRefEnd() {
        return this.referenceInterval.gethigh();
    }

    public int getContEnd() {
        return this.contigInterval.gethigh();
    }

    public int getContSt() {
        return this.contigInterval.getlow();
    }

    public Interval getReferenceInterval() {
        return this.referenceInterval;
    }

    public Interval getContigInterval() {
        return this.contigInterval;
    }

    public Reference getReference() {
        return this.reference;
    }

    public double getIdentity() {
        return this.id;
    }

    public int getRefAlignmentLength() {
        return this.referenceInterval.getlength();
    }

    public int getContigAlignmentLength() {
        return this.contigInterval.getlength();
    }

    public int overlapContig(Alignment a) {
        return this.contigInterval.overlap(a.getContigInterval());
    }

    public int overlapRef(Alignment a) {
        return this.referenceInterval.overlap(a.getReferenceInterval());
    }

    public String toString() {
        NumberFormat nr = Utilities.numberFormatter;
        StringBuilder sb = new StringBuilder();
        String ref_frame = this.refOr.toString();
        String contig_frame = this.contigOr.toString();
        sb.append("\t" + this.reference.getRefID() + "\t" + nr.format(this.referenceInterval.getlow()) + "\t" + nr.format(this.referenceInterval.gethigh()) + "\t" + ref_frame + "\t" + nr.format(this.contigInterval.getlow()) + "\t" + nr.format(this.contigInterval.gethigh()) + "\t" + contig_frame + "\t" + nr.format(this.id * 100.0) + "\t" + this.startTrimmed + "\t" + this.endTrimmed);
        return sb.toString();
    }

    @Override
    public int compareTo(Alignment o) {
        return this.getReferenceInterval().compareTo(o.getReferenceInterval());
    }
}

