/*
 * Decompiled with CFR 0.152.
 */
package NCTR.util.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ProgressDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected JLabel progLabel;
    protected JProgressBar progBar;
    protected JTextArea logTextArea;
    protected JPanel logPanel;
    protected UpdaterJob updaterJob;
    protected boolean isCanceled;

    public ProgressDialog(Window w, String title, boolean modal) {
        super(w, title, modal ? Dialog.ModalityType.APPLICATION_MODAL : Dialog.ModalityType.MODELESS);
        this.commonInit();
    }

    protected void commonInit() {
        this.updaterJob = new UpdaterJob();
        this.progBar = new JProgressBar();
        this.progBar.setIndeterminate(true);
        this.progLabel = new JLabel("Working ... ... ...");
        this.getContentPane().setLayout(new BorderLayout());
        JPanel center_pnl = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)center_pnl, "Center");
        center_pnl.add((Component)this.progLabel, "North");
        this.logPanel = new JPanel(new BorderLayout());
        this.logPanel.setPreferredSize(new Dimension(450, 200));
        this.logTextArea = new JTextArea();
        this.logTextArea.setEditable(false);
        this.logPanel.add(new JScrollPane(this.logTextArea));
        center_pnl.add((Component)this.logPanel, "Center");
        this.logPanel.setVisible(false);
        JPanel bar_panel = new JPanel(new BorderLayout());
        bar_panel.setBorder(BorderFactory.createEmptyBorder(50, 30, 5, 30));
        bar_panel.add((Component)this.progBar, "Last");
        this.getContentPane().add((Component)bar_panel, "First");
        this.getContentPane().add(Box.createHorizontalStrut(30), "West");
        this.getContentPane().add(Box.createHorizontalStrut(30), "East");
        JPanel btn_pnl = new JPanel(new FlowLayout(1));
        this.getContentPane().add((Component)btn_pnl, "South");
        JButton cancel_button = new JButton("Cancel");
        btn_pnl.add(cancel_button);
        cancel_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ProgressDialog.this.cancel();
            }
        });
        Dimension pref_label_size = this.progLabel.getPreferredSize();
        this.progLabel.setPreferredSize(new Dimension(pref_label_size.width * 3, pref_label_size.height));
        this.pack();
    }

    public void setShowLogPanel(boolean show_log_pnl) {
        this.logPanel.setVisible(show_log_pnl);
    }

    public void appendToLog(String msg) {
        this.logTextArea.append(String.valueOf(msg) + "\n");
    }

    public void appendToLog(String msg, boolean timeStamp) {
        if (timeStamp) {
            long currentTimeInMillis = System.currentTimeMillis();
            Date today = new Date(currentTimeInMillis);
            this.logTextArea.append(String.valueOf(msg) + "\n   [" + today.toString() + "]\n");
        } else {
            this.appendToLog(msg);
        }
    }

    public String getLogText() {
        return this.logTextArea.getText();
    }

    public JProgressBar getProgressBar() {
        return this.progBar;
    }

    public JLabel getMessageLabel() {
        return this.progLabel;
    }

    public synchronized void post(String note, int value) {
        this.updaterJob.setProgress(note, value);
        if (SwingUtilities.isEventDispatchThread()) {
            this.updaterJob.run();
            this.progLabel.paintImmediately(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
            this.progBar.paintImmediately(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        } else {
            SwingUtilities.invokeLater(this.updaterJob);
        }
    }

    public final void post(String note) {
        this.post(note, -1);
    }

    public final void post(int val) {
        this.post(null, val);
    }

    public synchronized void postSetRange(final int min, final int max) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.progBar.setIndeterminate(false);
            this.progBar.setMinimum(min);
            this.progBar.setMaximum(max);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressDialog.this.progBar.setIndeterminate(false);
                    ProgressDialog.this.progBar.setMinimum(min);
                    ProgressDialog.this.progBar.setMaximum(max);
                }
            });
        }
    }

    public synchronized void postSetVisible(final boolean visible) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.progBar.setVisible(visible);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressDialog.this.progBar.setVisible(visible);
                }
            });
        }
    }

    public final int getValue() {
        return this.progBar.getValue();
    }

    public void postClose() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.dispose();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressDialog.this.dispose();
                }
            });
        }
    }

    public void cancel() {
        this.isCanceled = true;
        this.dispose();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    public void setVisible(boolean vis) {
        if (vis) {
            this.pack();
        }
        super.setVisible(vis);
    }

    class UpdaterJob
    implements Runnable {
        protected String pendingNote;
        protected int pendingValue;

        public void setProgress(String note, int value) {
            this.pendingNote = note;
            this.pendingValue = value;
        }

        @Override
        public synchronized void run() {
            if (this.pendingValue != -1) {
                ProgressDialog.this.progBar.setValue(this.pendingValue);
                ProgressDialog.this.progBar.repaint();
            }
            if (this.pendingNote != null) {
                ProgressDialog.this.progLabel.setText(this.pendingNote);
                ProgressDialog.this.progLabel.repaint();
            }
        }
    }
}

