/*
 * Decompiled with CFR 0.152.
 */
package NCTR.util.math.la;

import NCTR.util.math.la.Matrix;
import java.io.Serializable;

public class CholeskyDecomposition
implements Serializable {
    private double[][] L;
    private int n;
    private boolean isspd;

    public CholeskyDecomposition(Matrix Arg) {
        double[][] A = Arg.getArray();
        this.n = Arg.getRowDimension();
        this.L = new double[this.n][this.n];
        this.isspd = Arg.getColumnDimension() == this.n;
        int j = 0;
        while (j < this.n) {
            double[] Lrowj = this.L[j];
            double d = 0.0;
            int k = 0;
            while (k < j) {
                double[] Lrowk = this.L[k];
                double s = 0.0;
                int i = 0;
                while (i < k) {
                    s += Lrowk[i] * Lrowj[i];
                    ++i;
                }
                Lrowj[k] = s = (A[j][k] - s) / this.L[k][k];
                d += s * s;
                this.isspd &= A[k][j] == A[j][k];
                ++k;
            }
            this.isspd &= (d = A[j][j] - d) > 0.0;
            this.L[j][j] = Math.sqrt(Math.max(d, 0.0));
            k = j + 1;
            while (k < this.n) {
                this.L[j][k] = 0.0;
                ++k;
            }
            ++j;
        }
    }

    public boolean isSPD() {
        return this.isspd;
    }

    public Matrix getL() {
        return new Matrix(this.L, this.n, this.n);
    }

    public Matrix solve(Matrix B) {
        int j;
        int j2;
        int i;
        if (B.getRowDimension() != this.n) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isspd) {
            throw new RuntimeException("Matrix is not symmetric positive definite.");
        }
        double[][] X = B.getArrayCopy();
        int nx = B.getColumnDimension();
        int k = 0;
        while (k < this.n) {
            i = k + 1;
            while (i < this.n) {
                j2 = 0;
                while (j2 < nx) {
                    double[] dArray = X[i];
                    int n = j2;
                    dArray[n] = dArray[n] - X[k][j2] * this.L[i][k];
                    ++j2;
                }
                ++i;
            }
            j = 0;
            while (j < nx) {
                double[] dArray = X[k];
                int n = j++;
                dArray[n] = dArray[n] / this.L[k][k];
            }
            ++k;
        }
        k = this.n - 1;
        while (k >= 0) {
            j = 0;
            while (j < nx) {
                double[] dArray = X[k];
                int n = j++;
                dArray[n] = dArray[n] / this.L[k][k];
            }
            i = 0;
            while (i < k) {
                j2 = 0;
                while (j2 < nx) {
                    double[] dArray = X[i];
                    int n = j2;
                    dArray[n] = dArray[n] - X[k][j2] * this.L[k][i];
                    ++j2;
                }
                ++i;
            }
            --k;
        }
        return new Matrix(X, this.n, nx);
    }
}

