/*
 * Decompiled with CFR 0.152.
 */
package NCTR.util;

import NCTR.util.XColorNames;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.StringTokenizer;

public class XpmParser {
    private BufferedReader input;
    private int lineNo = 0;
    private int width = 0;
    private int height = 0;
    private int nColors = 0;
    private int charsPerPixel = 0;
    private int[] colors = null;
    private Color[] colorTable;
    private byte[] pixmap = null;
    private String line;

    public XpmParser(InputStream is) {
        this.input = new BufferedReader(new InputStreamReader(is));
    }

    public XpmParser(Reader in) {
        this.input = new BufferedReader(in);
    }

    public boolean parse() {
        try {
            this.parseInput();
            return true;
        }
        catch (Exception e) {
            System.err.println("XpmParser: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[] getPixmap() {
        return this.pixmap;
    }

    public Color[] getColorTable() {
        return this.colorTable;
    }

    private void parseInput() throws Exception {
        this.checkForHeader();
        this.skipLineStartingWith("static char");
        this.readHintsLine();
        this.colors = new int[this.charsPerPixel * 256];
        this.colorTable = new Color[this.nColors];
        this.readColorTable();
        this.readPixels();
    }

    private void checkForHeader() throws Exception {
        this.readLine();
        if (this.line != null && this.line.startsWith("/*") && this.line.endsWith("*/")) {
            String tmp = this.line.substring(2);
            if (!(tmp = tmp.trim()).substring(0, 3).equals("XPM")) {
                System.err.println("XpmParser: warning: Not Xpm version 3.");
            }
            this.readLine();
        }
    }

    private void skipLineStartingWith(String skip) throws Exception {
        if (this.line == null) {
            throw new Exception("Invalid Xpm format, line: " + this.lineNo);
        }
        if (this.line.startsWith(skip)) {
            this.readLine();
        }
    }

    private void readHintsLine() throws Exception {
        if (this.line != null && this.line.startsWith("/*") && this.line.endsWith("*/")) {
            this.readLine();
        }
        if (this.line == null) {
            throw new Exception("Invalid Xpm format: unexpected EOF, line: " + this.lineNo);
        }
        int start = this.line.indexOf(34);
        int end = this.line.lastIndexOf(34);
        if (start < 0 || end < 0 || end <= start) {
            throw new Exception("Invalid Xpm format: hints line: " + this.lineNo);
        }
        String tmp = this.line.substring(start + 1, end);
        StringTokenizer st = new StringTokenizer(tmp);
        if (st.countTokens() < 4) {
            throw new Exception("Invalid Xpm format: hints line: " + this.lineNo);
        }
        try {
            this.width = Integer.parseInt(st.nextToken());
            this.height = Integer.parseInt(st.nextToken());
            this.nColors = Integer.parseInt(st.nextToken());
            this.charsPerPixel = Integer.parseInt(st.nextToken());
        }
        catch (Exception e) {
            throw new Exception("Invalid Xpm format: hints line: " + this.lineNo);
        }
        if (this.charsPerPixel > 2) {
            throw new Exception("Invalid Xpm format: Can only handle up to 2 chars per pixels");
        }
    }

    private void readColorTable() throws Exception {
        int i = 0;
        while (i < this.nColors) {
            this.readLine();
            if (this.line != null && this.line.startsWith("/*") && this.line.endsWith("*/")) {
                this.readLine();
            }
            if (this.line == null) {
                throw new Exception("Invalid Xpm format: unexpected EOF, line: " + this.lineNo);
            }
            int pos = this.line.indexOf(34);
            if (pos < 0) {
                throw new Exception("Invalid Xpm format: color table, line: " + this.lineNo);
            }
            String tmp = this.line.substring(pos + 1);
            int colorIndex = 0;
            int j = 0;
            while (j < this.charsPerPixel) {
                colorIndex = (colorIndex << 8) + tmp.charAt(j);
                ++j;
            }
            tmp = this.line.substring(pos + 1 + this.charsPerPixel);
            StringTokenizer st = new StringTokenizer(tmp, " \"\t\n\r");
            int state = 0;
            while (st.hasMoreTokens() && state < 2) {
                String token = st.nextToken();
                switch (state) {
                    case 0: {
                        if (!token.equals("c")) break;
                        ++state;
                        break;
                    }
                    case 1: {
                        this.colorTable[i] = this.parseColor(token);
                        this.colors[colorIndex] = i;
                        ++state;
                    }
                }
            }
            ++i;
        }
    }

    private void readPixels() throws Exception {
        this.readLine();
        if (this.line != null && this.line.startsWith("/*") && this.line.endsWith("*/")) {
            this.readLine();
        }
        if (this.line == null) {
            throw new Exception("Invalid Xpm format: EOF at line: " + this.lineNo);
        }
        int datasize = this.width * this.height;
        this.pixmap = new byte[datasize];
        int index = 0;
        while (this.line != null) {
            int start = this.line.indexOf(34);
            int end = this.line.lastIndexOf(34);
            if (start < 0 || end < 0 || end <= start) {
                throw new Exception("Invalid Xpm format: line: " + this.lineNo);
            }
            String tmp = this.line.substring(start + 1, end);
            int i = 0;
            while (i < tmp.length()) {
                int colorIndex = 0;
                int j = 0;
                while (j < this.charsPerPixel) {
                    colorIndex = (colorIndex << 8) + tmp.charAt(i++);
                    ++j;
                }
                this.pixmap[index++] = (byte)this.colors[colorIndex];
            }
            if (index >= datasize) {
                return;
            }
            this.readLine();
        }
    }

    private void readLine() {
        this.line = null;
        try {
            this.line = this.input.readLine();
        }
        catch (IOException e) {
            this.line = null;
        }
        if (this.line != null) {
            this.line = this.line.trim();
        }
        ++this.lineNo;
    }

    private Color parseColor(String aColor) {
        Color c = null;
        if (aColor.charAt(0) == '#') {
            switch (aColor.length()) {
                case 4: {
                    break;
                }
                case 7: {
                    Integer rgbValue = Integer.valueOf(aColor.substring(1), 16);
                    c = new Color(rgbValue);
                    break;
                }
                case 13: {
                    Integer rValue = Integer.valueOf(aColor.substring(1, 3), 16);
                    Integer gValue = Integer.valueOf(aColor.substring(5, 7), 16);
                    Integer bValue = Integer.valueOf(aColor.substring(9, 11), 16);
                    c = new Color(rValue, gValue, bValue);
                }
            }
            if (c == null) {
                c = Color.black;
            }
        } else if (aColor.equalsIgnoreCase("none")) {
            c = null;
        } else {
            int rgb = XColorNames.getRgb(aColor);
            if (rgb != Integer.MIN_VALUE) {
                c = new Color(rgb);
            }
            if (c == null) {
                c = Color.black;
            }
        }
        return c;
    }
}

