/*
 * Decompiled with CFR 0.152.
 */
package NCTR.util;

import NCTR.util.XbmParser;
import NCTR.util.XpmParser;
import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Hashtable;

public class XImageSource
implements ImageProducer {
    int width;
    int height;
    byte[] pixels;
    ColorModel colorModel;
    private boolean error = false;
    private ImageConsumer theConsumer;

    public XImageSource(int w, int h, int[] bits, Color fg, Color bg, boolean trans) {
        this.xbmInitialize(w, h, bits, fg, bg, trans);
    }

    public XImageSource(InputStream is, Color fg, Color bg, boolean trans) {
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        XbmParser parser = new XbmParser(r);
        if (parser.parse()) {
            this.xbmInitialize(parser.getWidth(), parser.getHeight(), parser.getBitmap(), fg, bg, trans);
        } else {
            this.error = true;
        }
    }

    public XImageSource(String[] data) {
        StringBuffer strBuf = new StringBuffer(1024);
        int i = 0;
        while (i < data.length) {
            strBuf.append("\"" + data[i] + "\"\n");
            ++i;
        }
        StringReader is = new StringReader(strBuf.toString());
        XpmParser parser = new XpmParser(is);
        if (parser.parse()) {
            this.xpmInitialize(parser.getWidth(), parser.getHeight(), parser.getPixmap(), parser.getColorTable());
        } else {
            this.error = true;
        }
    }

    public XImageSource(InputStream is) {
        XpmParser parser = new XpmParser(is);
        if (parser.parse()) {
            this.xpmInitialize(parser.getWidth(), parser.getHeight(), parser.getPixmap(), parser.getColorTable());
        } else {
            this.error = true;
        }
    }

    private void xbmInitialize(int w, int h, int[] bits, Color fg, Color bg, boolean trans) {
        this.width = w;
        this.height = h;
        byte[] colormap = new byte[6];
        int transIndex = -1;
        if (trans) {
            transIndex = 0;
            colormap[0] = 0;
            colormap[1] = 0;
            colormap[2] = 0;
        } else {
            colormap[0] = (byte)bg.getRed();
            colormap[1] = (byte)bg.getGreen();
            colormap[2] = (byte)bg.getBlue();
        }
        colormap[3] = (byte)fg.getRed();
        colormap[4] = (byte)fg.getGreen();
        colormap[5] = (byte)fg.getBlue();
        this.colorModel = new IndexColorModel(8, 2, colormap, 0, false, transIndex);
        this.pixels = new byte[this.width * this.height];
        int index = 0;
        int byteIndex = 0;
        int jMax = this.width / 8;
        try {
            int i = 0;
            while (i < this.height) {
                int j = 0;
                while (j < jMax) {
                    byte bitByte = (byte)bits[byteIndex];
                    int k = 0;
                    while (k < 8) {
                        int pixel = bitByte & 1 << k;
                        this.pixels[index] = pixel != 0 ? (byte)1 : 0;
                        ++index;
                        ++k;
                    }
                    ++byteIndex;
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.error = true;
        }
    }

    private void xpmInitialize(int w, int h, byte[] pixels, Color[] colorTable) {
        this.width = w;
        this.height = h;
        this.pixels = pixels;
        int nColors = colorTable.length;
        int cmSize = 3 * nColors;
        byte[] colormap = new byte[cmSize];
        int transIndex = -1;
        int i = 0;
        while (i < nColors) {
            if (colorTable[i] == null) {
                transIndex = i;
            } else {
                colormap[3 * i] = (byte)colorTable[i].getRed();
                colormap[3 * i + 1] = (byte)colorTable[i].getGreen();
                colormap[3 * i + 2] = (byte)colorTable[i].getBlue();
            }
            ++i;
        }
        this.colorModel = new IndexColorModel(8, nColors, colormap, 0, false, transIndex);
    }

    @Override
    public synchronized void addConsumer(ImageConsumer ic) {
        this.theConsumer = ic;
        this.produce();
        this.theConsumer = null;
    }

    @Override
    public synchronized boolean isConsumer(ImageConsumer ic) {
        return ic == this.theConsumer;
    }

    @Override
    public synchronized void removeConsumer(ImageConsumer ic) {
        if (this.theConsumer == ic) {
            this.theConsumer = null;
        }
    }

    @Override
    public void startProduction(ImageConsumer ic) {
        this.addConsumer(ic);
    }

    @Override
    public void requestTopDownLeftRightResend(ImageConsumer ic) {
    }

    private void produce() {
        if (this.theConsumer != null) {
            this.theConsumer.setDimensions(this.width, this.height);
        }
        if (this.theConsumer != null) {
            this.theConsumer.setProperties(new Hashtable());
        }
        if (this.theConsumer != null) {
            this.theConsumer.setColorModel(this.colorModel);
        }
        if (this.theConsumer != null) {
            this.theConsumer.setHints(30);
        }
        if (this.theConsumer != null) {
            this.theConsumer.setPixels(0, 0, this.width, this.height, this.colorModel, this.pixels, 0, this.width);
        }
        if (this.theConsumer != null) {
            if (!this.error) {
                this.theConsumer.imageComplete(3);
            } else {
                this.theConsumer.imageComplete(1);
            }
        }
    }
}

