/*
 * Decompiled with CFR 0.152.
 */
package NCTR.util;

import NCTR.util.Filter;
import NCTR.util.Func;
import NCTR.util.Func2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ListUtilities {
    public static <E> List<E> filter(List<E> l, Filter<E> f) {
        ArrayList<E> filtered_list = new ArrayList<E>();
        for (E e : l) {
            if (!f.passes(e)) continue;
            filtered_list.add(e);
        }
        return filtered_list;
    }

    public static <E> int firstIndex(List<E> l, Func<E, Boolean> f) {
        int l_size = l.size();
        int ix = 0;
        while (ix < l_size) {
            if (f.apply(l.get(ix)).booleanValue()) {
                return ix;
            }
            ++ix;
        }
        return -1;
    }

    public static <E> List<E> filter(List<E> l, Func<E, Boolean> f) {
        ArrayList<E> filtered_list = new ArrayList<E>();
        for (E e : l) {
            if (!f.apply(e).booleanValue()) continue;
            filtered_list.add(e);
        }
        return filtered_list;
    }

    public static <E> List<E> reverse(List<E> l) {
        ArrayList<E> rev = new ArrayList<E>(l);
        Collections.reverse(rev);
        return rev;
    }

    public static <E> List<E> tail(List<E> l) {
        return new ArrayList<E>(l.subList(1, l.size()));
    }

    public static <E> List<E> tailView(List<E> l) {
        return l.subList(1, l.size());
    }

    public static <E> E head(List<E> l) {
        return l.get(0);
    }

    public static <E> E last(List<E> l) {
        return l.get(l.size() - 1);
    }

    public static <E> List<E> concat(List<E> l1, List<E> l2) {
        ArrayList<E> cl = new ArrayList<E>(l1.size() + l2.size());
        cl.addAll(l1);
        cl.addAll(l2);
        return cl;
    }

    public static <E> List<E> cons(E e, List<E> l) {
        ArrayList<E> cl = new ArrayList<E>(1 + l.size());
        cl.add(e);
        cl.addAll(l);
        return cl;
    }

    public static <E> List<E> snoc(List<E> l, E e) {
        ArrayList<E> cl = new ArrayList<E>(l);
        cl.add(e);
        return cl;
    }

    public static <E1, E2, E3> List<E3> zipWith(Func2<E1, E2, E3> f, List<E1> l1, List<E2> l2) {
        Iterator<E1> it1 = l1.iterator();
        Iterator<E2> it2 = l2.iterator();
        ArrayList<E3> res = new ArrayList<E3>(Math.min(l1.size(), l2.size()));
        while (it1.hasNext() && it2.hasNext()) {
            res.add(f.apply(it1.next(), it2.next()));
        }
        return res;
    }

    public static <E> List<E> take(int n, List<E> l) {
        return new ArrayList<E>(ListUtilities.takeView(n, l));
    }

    public static <E> List<E> takeView(int n, List<E> l) {
        if (n >= l.size()) {
            return l;
        }
        return l.subList(0, n);
    }

    public static <E> List<E> drop(int n, List<E> l) {
        return new ArrayList<E>(ListUtilities.dropView(n, l));
    }

    public static <E> List<E> dropView(int n, List<E> l) {
        if (n >= l.size()) {
            return l.subList(l.size(), l.size());
        }
        return l.subList(n, l.size());
    }

    public static <E> List<List<E>> partition(List<E> l, int n) {
        ArrayList<List<List<E>>> partitions = new ArrayList<List<List<E>>>();
        List<E> rem = l;
        while (rem.size() > 0) {
            partitions.add(ListUtilities.takeView(n, rem));
            rem = ListUtilities.dropView(n, rem);
        }
        return partitions;
    }

    public static <E1, E2> List<E2> map(Func<E1, E2> f, List<E1> l) {
        ArrayList<E2> res = new ArrayList<E2>();
        for (E1 e1 : l) {
            res.add(f.apply(e1));
        }
        return res;
    }

    public static <E, A> A foldl(Func2<A, E, A> f, A a, List<E> l) {
        return ListUtilities.foldl(f, a, l, 0);
    }

    protected static <E, A> A foldl(Func2<A, E, A> f, A a, List<E> l, int front_ix) {
        if (front_ix == l.size()) {
            return a;
        }
        E e = l.get(front_ix);
        return ListUtilities.foldl(f, f.apply(a, e), l, front_ix + 1);
    }

    public static <E, A> A foldr(Func2<E, A, A> f, A init, List<E> l) {
        return ListUtilities.foldr(f, init, l, 0);
    }

    protected static <E, A> A foldr(Func2<E, A, A> f, A init, List<E> l, int front_ix) {
        if (front_ix == l.size()) {
            return init;
        }
        E head_e = l.get(front_ix);
        return f.apply(head_e, ListUtilities.foldr(f, init, l, front_ix + 1));
    }

    public static <A extends Comparable<? super A>> List<A> toSortedList(Collection<A> xs) {
        ArrayList<A> sorted_xs = new ArrayList<A>(xs);
        Collections.sort(sorted_xs);
        return sorted_xs;
    }

    public static <A> List<A> toSortedList(Collection<A> xs, Comparator<A> comp) {
        ArrayList<A> sorted_xs = new ArrayList<A>(xs);
        Collections.sort(sorted_xs, comp);
        return sorted_xs;
    }

    public static <A extends Comparable<? super A>> Comparator<List<A>> listComparator(A a) {
        return new Comparator<List<A>>(){

            @Override
            public int compare(List<A> l1, List<A> l2) {
                int n1 = l1.size();
                int n2 = l2.size();
                int i = 0;
                while (i < Math.min(n1, n2)) {
                    int c;
                    Comparable val1 = (Comparable)l1.get(i);
                    Comparable val2 = (Comparable)l2.get(i);
                    int n = val1 != null && val2 != null ? val1.compareTo(val2) : (val1 == null && val2 == null ? 0 : (c = val1 == null ? 1 : -1));
                    if (c != 0) {
                        return c;
                    }
                    ++i;
                }
                return n1 < n2 ? -1 : (n1 == n2 ? 0 : 1);
            }
        };
    }

    public static void main(String[] args) {
        List<Integer> ints = Arrays.asList(1, 2, 3, 4);
        Integer i = ListUtilities.foldl(new Func2<Integer, Integer, Integer>(){

            @Override
            public Integer apply(Integer i1, Integer i2) {
                return i1 + i2;
            }
        }, 0, ints);
        System.out.println(i);
    }
}

