/*
 * Decompiled with CFR 0.152.
 */
package NCTR.util;

import NCTR.util.FileFormatException;
import NCTR.util.IRowProcessor;
import NCTR.util.IntVector;
import NCTR.util.Pair;
import NCTR.util.RowColLabeledTabularData;
import NCTR.util.StringUtilities;
import NCTR.util.UserCanceledException;
import NCTR.util.swing.ProgressDialog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.JTable;
import javax.swing.ProgressMonitor;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.table.TableColumnModel;
import oracle.sql.BLOB;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class FileUtilities {
    public static String AUTOZIPPED_ENTRY_PREFIX = "FileUtilities_zipped_";
    static final int MAX_BUFFER_SIZE = 4096;

    public static RowColLabeledTabularData loadTabularData(String file, int row_label_cnum, int[] data_cnums, boolean col_hdrs_line_present) throws IOException {
        String[] row_labels_array;
        String line;
        String[] col_hdrs;
        ArrayList<String> row_labels = row_label_cnum > 0 ? new ArrayList<String>(5000) : null;
        ArrayList<double[]> data = new ArrayList<double[]>(5000);
        char delim = '\t';
        String delims = String.valueOf(delim);
        IntVector data_cixs = new IntVector(data_cnums.length);
        int i = 0;
        while (i < data_cnums.length) {
            data_cixs.add(data_cnums[i] - 1);
            ++i;
        }
        int row_label_cix = row_label_cnum - 1;
        BufferedReader rdr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "ISO-8859-1"));
        if (col_hdrs_line_present) {
            col_hdrs = new String[data_cnums.length];
            String hdrs_line = FileUtilities.nextNonBlankLineFrom(rdr);
            StringTokenizer col_hdrs_tkr = new StringTokenizer(hdrs_line, delims, true);
            int cix = 0;
            while (col_hdrs_tkr.hasMoreTokens()) {
                String tok = col_hdrs_tkr.nextToken();
                if (tok.length() == 1 && tok.charAt(0) == delim) {
                    ++cix;
                    continue;
                }
                int data_cix_ix = data_cixs.indexOf(cix);
                if (data_cix_ix < 0) continue;
                col_hdrs[data_cix_ix] = tok;
            }
        } else {
            col_hdrs = null;
        }
        while ((line = FileUtilities.nextNonBlankLineFrom(rdr)) != null) {
            int cix = 0;
            String tok = null;
            String row_label = null;
            double[] data_row = new double[data_cnums.length];
            Arrays.fill(data_row, Double.NaN);
            StringTokenizer tkr = new StringTokenizer(line, delims, true);
            while (tkr.hasMoreTokens()) {
                tok = tkr.nextToken();
                if (tok.length() == 1 && tok.charAt(0) == delim) {
                    ++cix;
                    continue;
                }
                if (cix == row_label_cix) {
                    row_label = tok.trim();
                    continue;
                }
                int data_cix_ix = data_cixs.indexOf(cix);
                if (data_cix_ix < 0) continue;
                try {
                    data_row[data_cix_ix] = Double.parseDouble(tok);
                }
                catch (NumberFormatException nfe) {
                    data_row[data_cix_ix] = Double.NaN;
                }
            }
            if (row_labels != null) {
                row_labels.add(row_label);
            }
            data.add(data_row);
        }
        Object data_array = new double[data.size()][];
        data_array = (double[][])data.toArray((T[])data_array);
        if (row_labels != null) {
            row_labels_array = new String[row_labels.size()];
            row_labels_array = row_labels.toArray(row_labels_array);
        } else {
            row_labels_array = null;
        }
        return new RowColLabeledTabularData((double[][])data_array, row_labels_array, col_hdrs);
    }

    public static TabularStringData readTabularStringData(File f, boolean omit_empty_rows) throws IOException, FileFormatException {
        if (FileUtilities.getExtensionLowerCase(f).equals("xls") || FileUtilities.getExtensionLowerCase(f).equals("xlsx")) {
            return FileUtilities.readExcelStringDataPOI(f, omit_empty_rows);
        }
        return FileUtilities.readTSVStringData(f, omit_empty_rows);
    }

    public static TabularStringData readExcelStringDataPOI(File excel_file, boolean omit_empty_rows) throws IOException, FileFormatException {
        if (excel_file == null) {
            throw new IllegalArgumentException("Excel file is required.");
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(excel_file);
            Workbook wb = WorkbookFactory.create((InputStream)fis);
            int num_rows = 0;
            ArrayList<String> col_names = new ArrayList<String>();
            ArrayList<List<String>> row_data = new ArrayList<List<String>>(num_rows);
            Sheet sheet = wb.getSheetAt(0);
            if (sheet.getPhysicalNumberOfRows() > 0) {
                for (Cell col_hdr_cell : sheet.getRow(0)) {
                    col_names.add(col_hdr_cell.getStringCellValue().trim());
                }
                num_rows = sheet.getPhysicalNumberOfRows();
                row_data = new ArrayList(num_rows - 1);
                DataFormatter formatter = new DataFormatter();
                FormulaEvaluator evaluator = wb.getCreationHelper().createFormulaEvaluator();
                int rix = 1;
                while (rix < num_rows) {
                    Row cur_row = sheet.getRow(rix);
                    if (cur_row != null) {
                        ArrayList<Object> row = new ArrayList<Object>(Collections.nCopies(col_names.size(), null));
                        boolean found_val_on_row = false;
                        int cix = Math.min(col_names.size(), cur_row.getLastCellNum()) - 1;
                        while (cix >= 0) {
                            Cell c = cur_row.getCell(cix, Row.CREATE_NULL_AS_BLANK);
                            String val = "";
                            val = c.getCellType() == 2 ? formatter.formatCellValue(c, evaluator) : formatter.formatCellValue(c);
                            if (val.length() > 0) {
                                row.set(cix, val);
                                found_val_on_row = true;
                            }
                            --cix;
                        }
                        if (found_val_on_row) {
                            row_data.add(row);
                        }
                    }
                    ++rix;
                }
            }
            TabularStringData tabularStringData = new TabularStringData(col_names, row_data);
            return tabularStringData;
        }
        catch (InvalidFormatException e) {
            throw new FileFormatException(excel_file, "The Excel Spreadsheet has some errors for reading.");
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public static TabularStringData readTSVStringData(File tsv_file, final boolean omit_empty_rows) throws IOException {
        final ArrayList<String> col_names = new ArrayList<String>();
        final ArrayList<List<String>> row_data = new ArrayList<List<String>>();
        IRowProcessor row_proc = new IRowProcessor(){
            int rowNum = 0;
            List<String> currDataRow;
            boolean valFoundOnRow;

            @Override
            public void rowBeginning() {
                ++this.rowNum;
                if (this.rowNum > 1) {
                    this.currDataRow = new ArrayList<Object>(Collections.nCopies(col_names.size(), null));
                }
                this.valFoundOnRow = false;
            }

            @Override
            public void processValue(int cix, String val) {
                String string = val = val == null || val.trim().length() == 0 ? null : val.trim();
                if (this.rowNum == 1) {
                    while (cix >= col_names.size()) {
                        col_names.add(null);
                    }
                    col_names.set(cix, val);
                } else if (val != null) {
                    this.valFoundOnRow = true;
                    if (cix < this.currDataRow.size()) {
                        this.currDataRow.set(cix, val);
                    }
                }
            }

            @Override
            public void rowEnding() {
                if (this.rowNum > 1 && (!omit_empty_rows || this.valFoundOnRow)) {
                    row_data.add(this.currDataRow);
                }
            }
        };
        FileUtilities.processRows(tsv_file, null, '\t', false, row_proc);
        return new TabularStringData(col_names, row_data);
    }

    public static String readColumnHeadersLine(BufferedReader rdr, String delims, int max_line_length, int min_delims_in_data_row, boolean expect_pure_numeric_tokens_only_in_data_rows, int[] hdr_line_num_holder, int[] first_data_line_num_holder) throws IOException {
        char delim = delims.charAt(0);
        rdr.mark(max_line_length);
        String line = null;
        int line_num = 0;
        while ((line = rdr.readLine()) != null && ++line_num != 0 && StringUtilities.countOccurrences(delim, line) < min_delims_in_data_row) {
            rdr.mark(max_line_length);
        }
        if (line != null && expect_pure_numeric_tokens_only_in_data_rows && FileUtilities.lineContainsNumberField(line, delims)) {
            rdr.reset();
            if (hdr_line_num_holder != null) {
                hdr_line_num_holder[0] = 0;
            }
            if (first_data_line_num_holder != null) {
                first_data_line_num_holder[0] = line_num;
            }
            return null;
        }
        if (hdr_line_num_holder != null) {
            hdr_line_num_holder[0] = line_num;
        }
        if (first_data_line_num_holder != null) {
            first_data_line_num_holder[0] = line_num + 1;
        }
        return line;
    }

    public static String readColumnHeadersLine(BufferedReader rdr, String delims, int max_line_length, int min_delims_in_data_row, int[] hdr_line_num_holder, int[] first_data_line_num_holder) throws IOException {
        return FileUtilities.readColumnHeadersLine(rdr, delims, max_line_length, min_delims_in_data_row, true, hdr_line_num_holder, first_data_line_num_holder);
    }

    public static String readColumnHeadersLine(BufferedReader rdr, String delims, int max_line_length, int min_delims_in_data_row) throws IOException {
        return FileUtilities.readColumnHeadersLine(rdr, delims, max_line_length, min_delims_in_data_row, true, null, null);
    }

    public static boolean lineContainsNumberField(String line, String delims) {
        StringTokenizer tkr = new StringTokenizer(line, delims);
        while (tkr.hasMoreTokens()) {
            String tok = tkr.nextToken().trim();
            try {
                Float.parseFloat(tok);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static long getCRCCheckSum(InputStream is) throws IOException {
        int n;
        CRC32 crc = new CRC32();
        byte[] buf = new byte[4096];
        while ((n = is.read(buf)) >= 0) {
            crc.update(buf, 0, n);
        }
        is.close();
        return crc.getValue();
    }

    public static void writeFileToBlob(Blob blob, File input_file) throws IOException, SQLException {
        try {
            FileUtilities.writeFileToBlob(blob, input_file, false);
        }
        catch (UserCanceledException uce) {
            System.err.println("Huh? FileUtilities.writeFileToBlob() threw UserCanceledException without progress dialog option !?");
        }
    }

    public static void writeFileToBlob(Blob blob, File input_file, boolean with_progress_dlg) throws IOException, SQLException, UserCanceledException {
        FileUtilities.writeFileToBlob(blob, input_file, with_progress_dlg, true);
    }

    public static void writeFileToBlob(Blob blob, File input_file, boolean with_progress_dlg, boolean zip_contents) throws IOException, SQLException, UserCanceledException {
        OutputStream os;
        InputStream is = new FileInputStream(input_file);
        ProgressMonitor prog_mon = null;
        if (with_progress_dlg) {
            is = new ProgressMonitorInputStream(null, "Inserting " + input_file.getName(), is);
            prog_mon = ((ProgressMonitorInputStream)is).getProgressMonitor();
        }
        OutputStream blob_os = ((BLOB)blob).getBinaryOutputStream();
        if (zip_contents) {
            ZipOutputStream zip_os = new ZipOutputStream(blob_os);
            ZipEntry ze = new ZipEntry(String.valueOf(AUTOZIPPED_ENTRY_PREFIX) + input_file.getName());
            zip_os.putNextEntry(ze);
            os = zip_os;
        } else {
            os = blob_os;
        }
        int chunk = ((BLOB)blob).getChunkSize();
        byte[] buffer = new byte[chunk];
        int length = -1;
        try {
            try {
                while ((length = is.read(buffer)) != -1) {
                    if (prog_mon != null && prog_mon.isCanceled()) {
                        throw new UserCanceledException();
                    }
                    os.write(buffer, 0, length);
                }
            }
            catch (InterruptedIOException iioe) {
                throw new UserCanceledException();
            }
        }
        finally {
            is.close();
            os.close();
        }
    }

    public static void writeBlobToFile(Blob blob, File out_file, boolean append) throws IOException, SQLException {
        FileOutputStream os = new FileOutputStream(out_file.getPath(), append);
        FileUtilities.writeZipBlobToStream(blob, os);
        os.close();
    }

    public static void writeZipBlobToStream(Blob blob, OutputStream os) throws IOException, SQLException {
        int n;
        byte[] buf = new byte[4096];
        if (blob == null) {
            throw new IllegalArgumentException("Blob is required.");
        }
        ZipInputStream is = new ZipInputStream(blob.getBinaryStream());
        is.getNextEntry();
        while ((n = is.read(buf)) >= 0) {
            os.write(buf, 0, n);
        }
        os.flush();
        is.close();
    }

    public static void writeBlobToFileNoZip(Blob blob, File out_file, boolean append) throws IOException, SQLException {
        FileOutputStream os = new FileOutputStream(out_file.getPath(), append);
        FileUtilities.writeBlobToStreamNoZip(blob, os);
        os.close();
    }

    public static void writeBlobToStreamNoZip(Blob blob, OutputStream os) throws IOException, SQLException {
        int n;
        byte[] buf = new byte[4096];
        InputStream is = blob.getBinaryStream();
        while ((n = is.read(buf)) >= 0) {
            os.write(buf, 0, n);
        }
        os.flush();
        is.close();
    }

    public static File tempTextFileFromExcelFile(File data_file, char delim, boolean skip_empty_rows) throws IOException, FileFormatException {
        String pref_str = data_file.getName().endsWith(".xlsx") ? "xlsx_" : "xls_";
        File tmp_file = File.createTempFile(pref_str, "_to_txt");
        try {
            Workbook wb = WorkbookFactory.create((InputStream)new FileInputStream(data_file));
            BufferedWriter os = new BufferedWriter(new FileWriter(tmp_file));
            Sheet sheet = wb.getSheetAt(0);
            DataFormatter formatter = new DataFormatter();
            FormulaEvaluator evaluator = wb.getCreationHelper().createFormulaEvaluator();
            Row row = null;
            int rix = 0;
            while (rix < sheet.getPhysicalNumberOfRows()) {
                row = sheet.getRow(rix);
                boolean found_val_on_row = false;
                StringBuilder str_row = new StringBuilder();
                Cell c0 = row.getCell(0);
                if (c0 != null) {
                    String val0 = "";
                    if (c0.getCellType() == 2) {
                        if (evaluator.evaluateFormulaCell(c0) == 5) {
                            throw new InvalidFormatException("Errors of formular calculation in the Excel file");
                        }
                        val0 = formatter.formatCellValue(c0, evaluator);
                    } else {
                        val0 = formatter.formatCellValue(c0);
                    }
                    str_row.append(val0);
                    if (val0.length() > 0) {
                        found_val_on_row = true;
                    }
                }
                int cix = 1;
                while (cix < row.getLastCellNum()) {
                    str_row.append(delim);
                    Cell c = row.getCell(cix);
                    String val = "";
                    if (c != null) {
                        if (c.getCellType() == 2) {
                            if (evaluator.evaluateFormulaCell(c) == 5) {
                                throw new InvalidFormatException("Errors of formular calculation in the Excel file");
                            }
                            val = formatter.formatCellValue(c, evaluator);
                        } else {
                            val = formatter.formatCellValue(c);
                        }
                        str_row.append(val);
                        if (val.length() > 0) {
                            found_val_on_row = true;
                        }
                    }
                    ++cix;
                }
                if (!skip_empty_rows || found_val_on_row) {
                    str_row.append(System.getProperty("line.separator", "\r\n"));
                    os.write(str_row.toString());
                }
                ++rix;
            }
            os.close();
        }
        catch (InvalidFormatException e) {
            throw new FileFormatException(data_file, "The Excel Spreadsheet has some errors for reading.");
        }
        return tmp_file;
    }

    public static File tempTextFileFromExcelFile(File data_file, char delim) throws IOException, FileFormatException {
        return FileUtilities.tempTextFileFromExcelFile(data_file, delim, false);
    }

    public static String nextNonBlankLineFrom(BufferedReader is) throws IOException {
        String line;
        while ((line = is.readLine()) != null && line.trim().length() == 0) {
        }
        return line;
    }

    public static List<String> getColumnHeaders(BufferedReader is, String delims, int max_line_len, int min_delims_in_data_row, boolean strip_surrounding_quotes) throws IOException {
        String hdrs_line = FileUtilities.readColumnHeadersLine(is, delims, max_line_len, min_delims_in_data_row);
        if (hdrs_line != null) {
            return FileUtilities.parseColumnHeadersLine(hdrs_line, delims, strip_surrounding_quotes);
        }
        return null;
    }

    public static List<String> getColumnNamesFromFirstLine(File file, String delims) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "ISO-8859-1"));
        String hdrs_line = br.readLine();
        return FileUtilities.parseColumnHeadersLine(hdrs_line, delims, false);
    }

    public static List<String> getColumnNamesFromFirstLine(File file) throws IOException, InvalidFormatException {
        if (FileUtilities.getExtensionLowerCase(file).equals("xls") || FileUtilities.getExtensionLowerCase(file).equals("xlsx")) {
            Workbook wb = WorkbookFactory.create((InputStream)new FileInputStream(file));
            Sheet sheet = wb.getSheetAt(0);
            Row row = sheet.getRow(0);
            ArrayList<String> vals = new ArrayList<String>(row.getLastCellNum());
            int i = 0;
            while (i < row.getLastCellNum()) {
                vals.add(row.getCell(i).getStringCellValue().trim());
                ++i;
            }
            return vals;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "ISO-8859-1"));
        String hdrs_line = br.readLine();
        return FileUtilities.parseColumnHeadersLine(hdrs_line, "\t", false);
    }

    public static List<String> parseColumnHeadersLine(String hdrs_line, String delims, boolean strip_surrounding_quotes) {
        ArrayList<String> col_hdrs = new ArrayList<String>(20);
        StringTokenizer tkr = new StringTokenizer(hdrs_line, delims, true);
        int cix = 0;
        while (tkr.hasMoreTokens()) {
            String tok = tkr.nextToken();
            if (tok.length() == 1 && delims.indexOf(tok.charAt(0)) != -1) {
                ++cix;
                continue;
            }
            tok = tok.trim();
            if (strip_surrounding_quotes && tok.startsWith("\"") && tok.endsWith("\"") && tok.length() >= 2) {
                tok = tok.substring(1, tok.length() - 1);
            }
            while (col_hdrs.size() < cix) {
                col_hdrs.add("");
            }
            col_hdrs.add(tok);
        }
        return col_hdrs;
    }

    public static Pair<String, Integer> findFirstFileLineInSet(File file, Set<String> lines, int max_lines_to_search) throws IOException {
        String line;
        if (lines.size() == 0) {
            return null;
        }
        BufferedReader is = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "ISO-8859-1"));
        int line_num = 0;
        while ((line = is.readLine()) != null) {
            if (max_lines_to_search > 0 && ++line_num > max_lines_to_search) break;
            if (!lines.contains(line)) continue;
            return Pair.make(line, line_num);
        }
        return null;
    }

    public static String getExtensionLowerCase(File f) {
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            return s.substring(i + 1).toLowerCase();
        }
        return "";
    }

    public static void exportTable(JTable table, Writer os, boolean sel_rows_only, boolean write_col_hdr_line, char delim, DateFormat dfmt) throws IOException {
        if (dfmt == null) {
            dfmt = new SimpleDateFormat("yyyy/MM/dd");
        }
        if (write_col_hdr_line) {
            TableColumnModel col_model = table.getColumnModel();
            boolean first_col = true;
            int vcix = 0;
            while (vcix < table.getColumnCount()) {
                if (first_col) {
                    first_col = false;
                } else {
                    os.write(delim);
                }
                os.write((String)col_model.getColumn(vcix).getHeaderValue());
                ++vcix;
            }
            os.write(10);
        }
        int last_row_ix = table.getRowCount() - 1;
        int rix = 0;
        while (rix <= last_row_ix) {
            if (!sel_rows_only || table.isRowSelected(rix)) {
                FileUtilities.outputRowAsText(table, rix, delim, dfmt, os);
                os.write(10);
            }
            ++rix;
        }
    }

    public static void outputRowAsText(JTable table, int rix, char sep_ch, DateFormat dfmt, Writer os) throws IOException {
        boolean first = true;
        int cols = table.getColumnCount();
        int vcix = 0;
        while (vcix < cols) {
            if (first) {
                first = false;
            } else {
                os.write(sep_ch);
            }
            Object val = table.getValueAt(rix, vcix);
            if (val != null) {
                String str_val;
                String string = str_val = val instanceof Date ? dfmt.format((Date)val) : val.toString();
                if (str_val.length() > 0) {
                    if (str_val.indexOf(sep_ch) != -1) {
                        str_val = str_val.replace(sep_ch, ' ');
                    }
                    os.write(str_val);
                }
            }
            ++vcix;
        }
    }

    public static void processRows(File data_file, boolean[] should_process_col, char delim, boolean skip_first_line, IRowProcessor row_proc) throws IOException {
        String line;
        BufferedReader is = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(data_file), "ISO-8859-1"));
        if (skip_first_line) {
            is.readLine();
        }
        String delims = String.valueOf(delim);
        while ((line = is.readLine()) != null) {
            row_proc.rowBeginning();
            StringTokenizer tkr = new StringTokenizer(line, delims, true);
            int cix = 0;
            while (tkr.hasMoreTokens()) {
                String tok = tkr.nextToken();
                if (tok.length() == 1 && delim == tok.charAt(0)) {
                    ++cix;
                    continue;
                }
                if (should_process_col != null && !should_process_col[cix]) continue;
                String val_str = tok.trim();
                row_proc.processValue(cix, val_str);
            }
            row_proc.rowEnding();
        }
        is.close();
    }

    public static Set<Integer> getNumericValuedColumns(File data_file, char sep, boolean first_row_is_col_names, final boolean allow_blanks) throws IOException {
        final HashSet<Integer> candidate_numeric_cixs = new HashSet<Integer>();
        final HashSet non_number_found_cixs = new HashSet();
        IRowProcessor row_proc = new IRowProcessor(){

            @Override
            public void rowBeginning() {
            }

            @Override
            public void processValue(int cix, String val) {
                if (val == null || val.length() == 0) {
                    if (!allow_blanks) {
                        non_number_found_cixs.add(cix);
                        candidate_numeric_cixs.remove(cix);
                    }
                } else if (!non_number_found_cixs.contains(cix)) {
                    try {
                        Float.parseFloat(val);
                        candidate_numeric_cixs.add(cix);
                    }
                    catch (NumberFormatException nfe) {
                        non_number_found_cixs.add(cix);
                        candidate_numeric_cixs.remove(cix);
                    }
                }
            }

            @Override
            public void rowEnding() {
            }
        };
        FileUtilities.processRows(data_file, null, sep, first_row_is_col_names, row_proc);
        return candidate_numeric_cixs;
    }

    public static void copyFilesToDir(File[] input_files, File output_dir) throws IOException {
        File[] fileArray = input_files;
        int n = input_files.length;
        int n2 = 0;
        while (n2 < n) {
            File input_file = fileArray[n2];
            File output_file = new File(output_dir, input_file.getName());
            FileUtilities.copy(input_file, output_file);
            ++n2;
        }
    }

    public static void copy(File input_file, File output_file) throws IOException {
        int n;
        byte[] buf = new byte[4096];
        FileInputStream is = new FileInputStream(input_file);
        FileOutputStream os = new FileOutputStream(output_file);
        while ((n = is.read(buf)) >= 0) {
            os.write(buf, 0, n);
        }
        os.close();
        is.close();
    }

    public static void deleteDir(File dir) throws IOException {
        File[] des = dir.listFiles();
        if (des != null) {
            File[] fileArray = des;
            int n = des.length;
            int n2 = 0;
            while (n2 < n) {
                File de = fileArray[n2];
                if (de.isDirectory()) {
                    FileUtilities.deleteDir(de);
                } else {
                    de.delete();
                }
                ++n2;
            }
        }
        dir.delete();
    }

    public static void exportLinesToFile(String file_path, List<String> lines) throws IOException {
        BufferedWriter bufferedWriter = null;
        try {
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(file_path));
                for (String line : lines) {
                    bufferedWriter.write(line);
                    bufferedWriter.newLine();
                }
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
                throw ex;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void zipFolder(String srcFolder, String destZipFile) throws IOException {
        ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(destZipFile));
        FileUtilities.addFolderToZip("", srcFolder, zip);
        zip.flush();
        zip.close();
    }

    private static void addToZip(String path, String srcFile, ZipOutputStream zip) throws IOException {
        File folder = new File(srcFile);
        if (folder.isDirectory()) {
            FileUtilities.addFolderToZip(path, srcFile, zip);
        } else {
            int len;
            byte[] buf = new byte[4096];
            FileInputStream in = new FileInputStream(srcFile);
            zip.putNextEntry(new ZipEntry(String.valueOf(path) + "/" + folder.getName()));
            while ((len = in.read(buf)) >= 0) {
                zip.write(buf, 0, len);
            }
        }
    }

    private static void addFolderToZip(String path, String srcFolder, ZipOutputStream zip) throws IOException {
        File folder = new File(srcFolder);
        String[] fileList = folder.list();
        int i = 0;
        while (i < fileList.length) {
            FileUtilities.addToZip(String.valueOf(path) + "/" + folder.getName(), String.valueOf(srcFolder) + "/" + fileList[i], zip);
            ++i;
        }
    }

    public static void unZip(File zip_file, File dest_dir) throws IOException {
        ZipFile zip = new ZipFile(zip_file);
        Enumeration<? extends ZipEntry> entries_it = zip.entries();
        while (entries_it.hasMoreElements()) {
            FileUtilities.extractZipEntry(entries_it.nextElement(), zip, dest_dir);
        }
    }

    public static void extractZipEntry(ZipEntry entry, ZipFile zip_file, File dest_dir) throws IOException {
        String entry_name = entry.getName();
        File entry_file = new File(dest_dir, entry_name);
        if (entry.isDirectory()) {
            if (!entry_file.isDirectory() && !entry_file.mkdirs()) {
                throw new IOException("Couldn't make directory " + entry_file.getPath());
            }
        } else {
            File parent_dir = entry_file.getParentFile();
            if (!parent_dir.isDirectory() && !parent_dir.mkdirs()) {
                throw new IOException("Couldn't make directory " + parent_dir.getPath());
            }
            FileOutputStream os = new FileOutputStream(entry_file);
            InputStream is = zip_file.getInputStream(entry);
            int n = 0;
            byte[] buf = new byte[4096];
            while ((n = is.read(buf)) >= 0) {
                os.write(buf, 0, n);
            }
            is.close();
            os.close();
        }
    }

    public static void unZipStream(InputStream from_is, File dest_dir) throws IOException {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(from_is);
        while ((entry = zis.getNextEntry()) != null) {
            FileUtilities.extractZipEntryFromStream(entry, zis, dest_dir);
        }
    }

    public static void extractZipEntryFromStream(ZipEntry entry, ZipInputStream zis, File dest_dir) throws IOException {
        int MAX_BUFFER_SIZE = 4096;
        String entry_name = entry.getName();
        File entry_file = new File(dest_dir, entry_name);
        if (entry.isDirectory()) {
            if (!entry_file.isDirectory() && !entry_file.mkdirs()) {
                throw new IOException("Couldn't make directory " + entry_file.getPath());
            }
        } else {
            File parent_dir = entry_file.getParentFile();
            if (!parent_dir.isDirectory() && !parent_dir.mkdirs()) {
                throw new IOException("Couldn't make directory " + parent_dir.getPath());
            }
            FileOutputStream os = new FileOutputStream(entry_file);
            try {
                int n = 0;
                byte[] buf = new byte[4096];
                while ((n = zis.read(buf)) >= 0) {
                    os.write(buf, 0, n);
                }
            }
            finally {
                os.close();
            }
            zis.closeEntry();
        }
    }

    public static String getFileName(URL url) {
        String file_name = url.getFile();
        return file_name.substring(file_name.lastIndexOf(47) + 1);
    }

    public static File fetchFromURL(URL url, File dest_dir, boolean resume_prev, ProgressDialog prog_dlg) throws IOException, UserCanceledException {
        FileOutputStream os = null;
        InputStream is = null;
        try {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            File dest_file = new File(dest_dir, FileUtilities.getFileName(url));
            os = new FileOutputStream(dest_file, resume_prev);
            if (resume_prev) {
                conn.setRequestProperty("Range", "bytes=" + dest_file.length() + "-");
            }
            conn.connect();
            if (conn.getResponseCode() / 100 != 2) {
                throw new IOException("Could not fetch file " + url + ", server returned response code " + conn.getResponseCode());
            }
            int content_len = conn.getContentLength();
            if (prog_dlg != null) {
                prog_dlg.postSetRange(0, content_len + (int)(0.1 * (double)content_len));
                prog_dlg.post("Downloading " + dest_file.getName());
            }
            is = conn.getInputStream();
            byte[] buf = new byte[4096];
            int n = 0;
            int total_read = 0;
            while ((n = is.read(buf)) >= 0) {
                os.write(buf, 0, n);
                total_read += n;
                if (prog_dlg == null) continue;
                if (prog_dlg.isCanceled()) {
                    throw new UserCanceledException();
                }
                prog_dlg.post(total_read);
            }
            File file = dest_file;
            return file;
        }
        finally {
            if (os != null) {
                os.close();
            }
            if (is != null) {
                is.close();
            }
        }
    }

    public static String toLegalFileName(String candidate_filename) {
        return candidate_filename.replaceAll("[\"/\\\\?<>:*]", "_");
    }

    public static class TabularStringData {
        List<String> colNames;
        List<List<String>> rowData;

        public TabularStringData(List<String> col_names, List<List<String>> row_data) {
            this.colNames = col_names;
            this.rowData = row_data;
        }

        public List<String> getColumnNames() {
            return this.colNames;
        }

        public List<List<String>> getRowData() {
            return this.rowData;
        }
    }
}

