/*
 * Decompiled with CFR 0.152.
 */
package NCTR.graph.SciGraph;

import NCTR.graph.SciGraph.SgGraphItem;
import NCTR.graph.SciGraph.Vector;
import java.awt.Color;

public class SgSphere<K, L>
extends SgGraphItem<K, L> {
    private static final double Pi = 3.141592638;
    private double radius = 0.7;
    private L note = null;

    public void setRadius(double _radius) {
        this.radius = _radius;
        this.parseFunction();
    }

    public SgSphere(double x, double y, double z, K id, Color surfaceColor) {
        this(x, y, z, surfaceColor);
        this.setID(id);
    }

    public SgSphere(double x, double y, double z, Color _surfaceColor) {
        this.xLoc = x;
        this.yLoc = y;
        this.zLoc = z;
        this.surfaceColor = _surfaceColor;
        this.visible = true;
        this.isSurface = false;
        this.fillSurface = true;
        this.curveWidth = 2;
        this.absoluteWidth = false;
        this.stepH = 14;
        this.stepV = 14;
        this.parseFunction();
    }

    @Override
    public String generateTestCase(String dataType) {
        String className = this.getClass().getName();
        String colorConstructor = "new java.awt.Color(" + this.surfaceColor.getRed() + "," + this.surfaceColor.getGreen() + "," + this.surfaceColor.getBlue() + ",255)";
        return "new " + className + dataType + "(" + this.xLoc + "," + this.yLoc + "," + this.zLoc + "," + colorConstructor + ")";
    }

    @Override
    public void parseFunction() {
        this.coords = new Vector[this.stepH][this.isSurface ? 1 : this.stepV];
        int i = 0;
        while (i < this.stepH) {
            double d = (float)i / (float)(this.stepH - 1);
            int j = 0;
            while (j < (this.isSurface ? 1 : this.stepV)) {
                double d1 = (float)j / (float)(this.stepV - 1);
                double u = 3.141592638 * d;
                double v = 6.283185276 * d1;
                double r = Math.sin(u);
                double x = r * Math.cos(v) * this.radius + this.xLoc;
                double y = r * Math.sin(v) * this.radius + this.yLoc;
                double z = Math.cos(u) * this.radius + this.zLoc;
                try {
                    this.coords[i][j] = new Vector(x, y, z);
                }
                catch (Exception exception) {
                    this.coords[i][j] = new Vector(Double.NaN, Double.NaN, Double.NaN);
                }
                ++j;
            }
            ++i;
        }
        this.allPartsList = null;
    }

    public L getAnnotation() {
        return this.note;
    }

    public void setAnnotation(L _note) {
        this.note = _note;
    }
}

