/*
 * Decompiled with CFR 0.152.
 */
package NCTR.graph.SciGraph;

import NCTR.graph.SciGraph.ColorRGB;
import NCTR.graph.SciGraph.SciGraph;
import NCTR.graph.SciGraph.SgGraphItemPart;
import NCTR.graph.SciGraph.Vector;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;

public class SgPlate
extends SgGraphItemPart {
    private Vector vec0;
    private Vector vec1;
    private Vector vec2;
    private Vector vec3;
    private ColorRGB wireColor;
    private ColorRGB plateColor;
    private boolean noLines = false;
    private Polygon poly = new Polygon();
    private Color curveColor = null;
    private Color surfaceColor = null;
    private Vector vec4 = new Vector();
    private Vector vec5 = new Vector();
    private Vector vec6 = new Vector();
    private Vector vec7 = new Vector();
    static final double SHINE_INTENSITY = 0.35;

    public boolean isNoLines() {
        return this.noLines;
    }

    public void setNoLines(boolean noLines) {
        this.noLines = noLines;
    }

    @Override
    public void setTransparency(double transparant) {
        Color c = this.curveColor;
        this.curveColor = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(255.0 * transparant));
        c = this.surfaceColor;
        this.surfaceColor = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(255.0 * transparant));
    }

    @Override
    public void render(Graphics2D graphics2d) {
        if (!this.renderable) {
            return;
        }
        if (this.surfaceColor != null) {
            graphics2d.setColor(this.surfaceColor);
            graphics2d.fill(this.poly);
        }
        if (this.curveColor != null) {
            graphics2d.setColor(this.curveColor);
            graphics2d.draw(this.poly);
        }
    }

    public SgPlate(Vector _vec, Vector _vec1, Vector _vec2, Vector _vec3, Color _wireColor, Color _plateColor, boolean _noLines) {
        this.vec0 = _vec;
        this.vec1 = _vec1;
        this.vec2 = _vec2;
        this.vec3 = _vec3;
        this.wireColor = new ColorRGB(_wireColor);
        this.plateColor = new ColorRGB(_plateColor);
        this.noLines = _noLines;
        this.surfaceColor = this.plateColor.getColor();
        this.curveColor = this.wireColor.getColor();
        this.renderable = false;
    }

    private double calcShine(Vector eyeVec) {
        double d = 0.0;
        double shineyNess = 0.25;
        this.vec4.assignDiff(this.vec1, this.vec0);
        this.vec5.assignDiff(this.vec2, this.vec1);
        this.vec6.assignDiff(this.vec3, this.vec2);
        this.vec7.assignDiff(this.vec0, this.vec3);
        Vector vec9 = this.vec4.crossProduct(this.vec5);
        vec9 = vec9.add(this.vec6.crossProduct(this.vec7));
        d += vec9.normalize().dotProduct(eyeVec);
        d = Math.abs(d);
        d = (d - 1.0) / (1.0 - shineyNess) + 1.0;
        if (d < 0.0) {
            d = 0.0;
        } else if (d > 1.0) {
            d = 1.0;
        }
        return d;
    }

    @Override
    public boolean recalcVisible(SciGraph<?, ?> sg) {
        Vector vecA = sg.project(this.vec0);
        Vector vecB = sg.project(this.vec1);
        Vector vecC = sg.project(this.vec2);
        Vector vecD = sg.project(this.vec3);
        if (vecA.z < 0.0 || vecB.z < 0.0 || vecC.z < 0.0 || vecD.z < 0.0) {
            this.renderable = false;
            return this.renderable;
        }
        this.dist = (vecA.z + vecB.z + vecC.z + vecD.z) / 4.0;
        double d1 = sg.getBlendAmt(this.dist);
        if (d1 >= 1.0) {
            this.renderable = false;
            return this.renderable;
        }
        this.poly.reset();
        this.poly.addPoint((int)vecA.x, -((int)vecA.y));
        this.poly.addPoint((int)vecB.x, -((int)vecB.y));
        this.poly.addPoint((int)vecC.x, -((int)vecC.y));
        this.poly.addPoint((int)vecD.x, -((int)vecD.y));
        ColorRGB bg = new ColorRGB(sg.getBgColor());
        Vector eye = sg.getEyeDirection();
        this.plateColor.blend(ColorRGB.WHITE, this.calcShine(eye) * 0.35);
        this.plateColor.continueBlend(bg, this.calcShine(eye) * 0.35);
        this.surfaceColor = this.plateColor.getColor();
        if (this.noLines) {
            this.curveColor = this.surfaceColor;
        } else {
            this.wireColor.blend(bg, d1);
            this.curveColor = this.wireColor.getColor();
        }
        this.renderable = true;
        return this.renderable;
    }
}

