/*
 * Decompiled with CFR 0.152.
 */
package NCTR.graph.SciGraph;

import NCTR.graph.SciGraph.SciGraph;
import NCTR.graph.SciGraph.SgGraphItemPart;
import NCTR.graph.SciGraph.Utils;
import NCTR.graph.SciGraph.Vector;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class SgLine
extends SgGraphItemPart {
    private Vector vStart;
    private Vector vEnd;
    private Color color = null;
    private int width;
    private boolean flag;
    private Vector vecS;
    private Vector vecE;
    private Color curveColor;
    private int curveWidth = 1;

    @Override
    public boolean recalcVisible(SciGraph<?, ?> sg) {
        this.vecS = sg.project(this.vStart);
        this.vecE = sg.project(this.vEnd);
        if (this.vecS.z < 0.0 || this.vecE.z < 0.0) {
            this.renderable = false;
            return this.renderable;
        }
        this.dist = (this.vecS.z + this.vecE.z) / 2.0;
        double d = sg.getBlendAmt(this.dist);
        if (d >= 1.0) {
            this.renderable = false;
            return this.renderable;
        }
        this.curveColor = Utils.blendColors(this.color, sg.getBgColor(), d);
        this.curveWidth = this.flag ? this.width : (int)(1.0 / this.dist * (double)this.width);
        this.renderable = true;
        return this.renderable;
    }

    @Override
    public void render(Graphics2D graphics2d) {
        if (!this.renderable) {
            return;
        }
        Stroke stroke = graphics2d.getStroke();
        graphics2d.setStroke(new BasicStroke(this.curveWidth, 1, 1));
        graphics2d.setColor(this.curveColor);
        graphics2d.drawLine((int)this.vecS.x, -((int)this.vecS.y), (int)this.vecE.x, -((int)this.vecE.y));
        graphics2d.setStroke(stroke);
    }

    public SgLine(Vector _vecA, Vector _vecB, Color _color, int _width, boolean _flag) {
        this.vStart = _vecA;
        this.vEnd = _vecB;
        this.color = _color;
        this.width = _width;
        this.flag = _flag;
        this.curveColor = this.color;
    }

    @Override
    public void setTransparency(double transparant) {
        this.curveColor = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), (int)(255.0 * transparant));
    }
}

