/*
 * Decompiled with CFR 0.152.
 */
package NCTR.graph.SciGraph;

import NCTR.graph.SciGraph.SgGraphAxes;
import NCTR.graph.SciGraph.SgGraphItem;
import NCTR.graph.SciGraph.SgGraphItemList;
import NCTR.graph.SciGraph.SgGraphItemPart;
import NCTR.graph.SciGraph.SgGrid;
import NCTR.graph.SciGraph.SgSphere;
import NCTR.graph.SciGraph.Utils;
import NCTR.graph.SciGraph.Vector;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;

public class SciGraph<K, L>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private String title = "";
    private Vector eyePosition = new Vector(1.4, 0.5, 1.0);
    private Vector eyeDirection = new Vector(-0.77, -0.27, -0.57).normalize();
    private Vector up = new Vector(0.0, 1.0, 0.0);
    private Vector screenUp = null;
    private Vector screenRight = null;
    private double fov = 90.0;
    private double scale = 0.0;
    private boolean backCulling = true;
    private Color bgColor = new Color(254, 254, 228);
    public boolean fogEnabled = false;
    public double fogStart = 0.0;
    public double fogEnd = 5.0;
    private Timer timer = null;
    private KeyBoard keyBoard = null;
    private SgGraphItemList<K, L> itemsList = new SgGraphItemList();
    public SgGraphAxes axesDefinition = new SgGraphAxes();
    private double initialEyeX = 1.4;
    private double initialEyeY = 0.5;
    private double initialEyeZ = 1.0;
    private String lastDirectory = null;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String s) {
        this.title = s;
    }

    public Vector getEyeDirection() {
        return this.eyeDirection;
    }

    public boolean isBackCulling() {
        return this.backCulling;
    }

    public void toggleBackCulling() {
        this.backCulling = !this.backCulling;
        this.refresh();
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(Color c) {
        this.bgColor = c;
    }

    public double getBlendAmt(double dist) {
        if (this.fogEnabled) {
            double d = (dist - this.fogStart) / (this.fogEnd - this.fogStart);
            if (d > 1.0) {
                return 1.0;
            }
            if (d < 0.0) {
                return 0.0;
            }
            return d;
        }
        return 0.0;
    }

    public void add(SgGraphItem<K, L> item) {
        this.itemsList.add(item);
    }

    public SgGraphItem<K, L> findByID(K ID) {
        int i = 0;
        while (i < this.itemsList.size()) {
            SgGraphItem<K, L> item = this.itemsList.get(i);
            if (ID.equals(item.getID())) {
                return item;
            }
            ++i;
        }
        return null;
    }

    public void setUseAxisTicks(boolean flag) {
        this.axesDefinition.setUseAxesTicks(flag);
    }

    public void setObsColor(List<K> selObsIxs, Color new_color) {
        int i = 0;
        while (i < this.itemsList.size()) {
            K id;
            boolean found;
            SgGraphItem<K, L> item = this.itemsList.get(i);
            if (item.isData() && (found = this.idFoundInList(id = item.getID(), selObsIxs))) {
                item.surfaceColor = new_color;
            }
            ++i;
        }
    }

    private boolean idFoundInList(K id, List<K> sel_obs_ixs) {
        boolean found = false;
        for (K ixs : sel_obs_ixs) {
            if (!ixs.equals(id)) continue;
            found = true;
            break;
        }
        return found;
    }

    public void setSelectedObservations(List<K> sel_obs_ixs) throws RemoteException {
        int i = 0;
        while (i < this.itemsList.size()) {
            SgGraphItem<K, L> item = this.itemsList.get(i);
            if (item.isData()) {
                K id = item.getID();
                boolean found = this.idFoundInList(id, sel_obs_ixs);
                item.setSelected(found);
            }
            ++i;
        }
    }

    public void clearSelection() {
        int i = 0;
        while (i < this.itemsList.size()) {
            SgGraphItem<K, L> item = this.itemsList.get(i);
            if (item.isData()) {
                item.setSelected(false);
            }
            ++i;
        }
    }

    public void setDataTransparency(double transparant) {
        int i = 0;
        while (i < this.itemsList.size()) {
            SgGraphItem<K, L> item = this.itemsList.get(i);
            if (item.isData()) {
                item.setTransparency(transparant);
            }
            ++i;
        }
    }

    public void setShapeSize(double scale) {
        int i = 0;
        while (i < this.itemsList.size()) {
            SgGraphItem<K, L> item = this.itemsList.get(i);
            if (item.isData() && item instanceof SgSphere) {
                SgSphere s = (SgSphere)item;
                s.setRadius(scale);
            }
            ++i;
        }
    }

    public void autoScaleData() {
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        double maxZ = 0.0;
        boolean firstTime = true;
        int i = 0;
        while (i < this.itemsList.size()) {
            SgGraphItem<K, L> item = this.itemsList.get(i);
            if (item.isData()) {
                double x = item.getX();
                double y = item.getY();
                double z = item.getZ();
                if (firstTime) {
                    minX = maxX = x;
                    minY = maxY = y;
                    minZ = maxZ = z;
                    firstTime = false;
                } else {
                    if (minX > x) {
                        minX = x;
                    }
                    if (minY > y) {
                        minY = y;
                    }
                    if (minZ > z) {
                        minZ = z;
                    }
                    if (maxX < x) {
                        maxX = x;
                    }
                    if (maxY < y) {
                        maxY = y;
                    }
                    if (maxZ < z) {
                        maxZ = z;
                    }
                }
            }
            ++i;
        }
        System.out.println("SciGraph.autoScaleData() " + minX + ", " + minY + ", " + minZ + ", " + maxX + ", " + maxY + ", " + maxZ);
        this.scaleGraph(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void useGridColor(boolean flag) {
        int i = 0;
        while (i < this.itemsList.size()) {
            SgGraphItem<K, L> item = this.itemsList.get(i);
            if (item instanceof SgGrid) {
                SgGrid g = (SgGrid)item;
                g.useSurfaceColor(flag);
            }
            ++i;
        }
        this.recalcVisible();
        this.repaint();
    }

    public void refresh() {
        this.recalcVisible();
        this.repaint();
    }

    public void scaleGrid(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        int i = 0;
        while (i < this.itemsList.size()) {
            SgGraphItem<K, L> item = this.itemsList.get(i);
            if (item instanceof SgGrid) {
                SgGrid g = (SgGrid)item;
                g.setGridMin(minX, minY, minZ);
                g.setGridMax(maxX, maxY, maxZ);
            }
            ++i;
        }
    }

    public void scaleGraph(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.axesDefinition.setAxesMin(minX, minY, minZ);
        this.axesDefinition.setAxesMax(maxX, maxY, maxZ);
        minX -= Math.abs(minX * 0.4);
        minY -= Math.abs(minY * 0.4);
        minZ -= Math.abs(minZ * 0.4);
        this.scaleGrid(minX, minY, minZ, maxX *= 1.4, maxY *= 1.4, maxZ *= 1.4);
        this.resetView(maxX * 1.8, maxY * 1.65, maxZ * 1.8);
    }

    public void clearGraph() {
        this.itemsList.clear();
    }

    public void clearData() {
        SgGraphItemList<K, L> keepItems = new SgGraphItemList<K, L>();
        int i = 0;
        while (i < this.itemsList.size()) {
            SgGraphItem<K, L> item = this.itemsList.get(i);
            if (!item.isData()) {
                keepItems.add(item);
            }
            ++i;
        }
        this.itemsList.clear();
        this.itemsList = keepItems;
    }

    public double getFov() {
        return this.fov;
    }

    public void setFov(double d) {
        this.fov = d;
        this.recalcScale();
    }

    public void resetView() {
        this.resetView(this.initialEyeX, this.initialEyeY, this.initialEyeZ);
    }

    public void resetView(double eyeX, double eyeY, double eyeZ) {
        this.initialEyeX = eyeX;
        this.initialEyeY = eyeY;
        this.initialEyeZ = eyeZ;
        this.eyePosition = new Vector(eyeX, eyeY, eyeZ);
        this.eyeDirection = this.eyePosition.scalarDivide(-2.0).normalize();
        this.up = new Vector(0.0, 1.0, 0.0);
        this.fov = 90.0;
        this.scale = 0.0;
        this.recalcUpRight();
        this.recalcScale();
        this.refresh();
    }

    private void recalcScale() {
        Dimension dimension = this.getSize();
        double d = Math.sqrt(dimension.height * dimension.height + dimension.width * dimension.width);
        this.scale = d / (2.0 * Math.tan(this.fov * Math.PI / 180.0 / 2.0) * 1.0);
    }

    public SciGraph() {
        this.recalcUpRight();
        this.recalcScale();
        this.itemsList.clear();
        this.setPreferredSize(new Dimension(320, 240));
        this.keyBoard = new KeyBoard();
        OnMouse onmouse = new OnMouse();
        this.addMouseListener(onmouse);
        this.addMouseMotionListener(onmouse);
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mousewheelevent) {
                SciGraph.this.keyBoard.velForward = (double)mousewheelevent.getWheelRotation() * 7.0;
                SciGraph.this.timer.start();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentevent) {
                SciGraph.this.recalcScale();
            }
        });
        this.addKeyListener(new OnKey());
        this.recalcUpRight();
        this.timer = new Timer(50, new TimerListener());
    }

    private void recalcUpRight() {
        this.screenUp = new Vector(this.up);
        this.screenUp = this.screenUp.substract(this.eyeDirection.scalarMult(this.eyeDirection.dotProduct(this.up)));
        this.screenUp = this.screenUp.normalize();
        this.screenRight = this.screenUp.crossProduct(this.eyeDirection).normalize();
    }

    public boolean isAxisShown() {
        return this.axesDefinition.isAxisShown();
    }

    public void setShowAxis(boolean flag) {
        this.axesDefinition.setShowAxis(flag);
        this.repaint();
    }

    public void setAxesLabels(String x, String y, String z) {
        this.axesDefinition.setAxesLabels(x, y, z);
        this.repaint();
    }

    private void showEyeView() {
        System.out.println("eyePosition = " + this.eyePosition);
        System.out.println("eyeDirection = " + this.eyeDirection);
    }

    private void cameraForward(double d) {
        this.eyePosition = this.eyePosition.add(this.eyeDirection.scalarMult(d));
        this.recalcVisible();
        this.repaint();
    }

    private void cameraRotate(double d, double d1, boolean flag) {
        Vector vec = null;
        if (flag) {
            vec = new Vector(this.eyePosition.dotProduct(this.eyeDirection), this.eyePosition.dotProduct(this.screenUp), this.eyePosition.dotProduct(this.screenRight));
        }
        this.eyeDirection = this.eyeDirection.substract(this.screenRight.scalarMult(d));
        this.eyeDirection = this.eyeDirection.add(this.screenUp.scalarMult(d1));
        this.eyeDirection = this.eyeDirection.normalize();
        if (flag) {
            this.recalcUpRight();
            this.eyePosition = this.eyeDirection.scalarMult(vec.x).add(this.screenUp.scalarMult(vec.y)).add(this.screenRight.scalarMult(vec.z));
        }
        if (this.eyeDirection.y > -0.9 && this.eyeDirection.y < 0.9) {
            int i = this.up.y <= 0.0 ? -1 : 1;
            double d2 = (double)i * this.screenUp.y;
            double d3 = (double)i * this.eyeDirection.y;
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            this.up = this.screenUp.scalarMult(d2 / d4).add(this.eyeDirection.scalarMult(d3 / d4));
            this.up = this.up.add(new Vector(0.0, 0.1 * (double)i, 0.0)).normalize();
        } else {
            this.up = this.screenUp;
        }
        this.recalcUpRight();
        this.recalcVisible();
        this.repaint();
    }

    private void cameraTranslate(double d, double d1) {
        this.eyePosition = this.eyePosition.substract(this.screenRight.scalarMult(d));
        this.eyePosition = this.eyePosition.add(this.screenUp.scalarMult(d1));
        this.recalcVisible();
        this.repaint();
    }

    private void cameraBank(double d) {
        this.up = this.screenUp.add(this.screenRight.scalarMult(d)).normalize();
        this.recalcUpRight();
        this.recalcVisible();
        this.repaint();
    }

    public Vector project(Vector vec) {
        double x = vec.x;
        double y = vec.y;
        double z = vec.z;
        double d = this.eyeDirection.dotProduct(x -= this.eyePosition.x, y -= this.eyePosition.y, z -= this.eyePosition.z);
        x /= d;
        y /= d;
        z /= d;
        Vector vec1 = new Vector(this.scale * this.screenRight.dotProduct(x -= this.eyeDirection.x, y -= this.eyeDirection.y, z -= this.eyeDirection.z), this.scale * this.screenUp.dotProduct(x, y, z), d);
        return vec1;
    }

    private void recalcVisible() {
        this.axesDefinition.recalcVisible(this);
        int i = 0;
        while (i < this.itemsList.size()) {
            SgGraphItem<K, L> item = this.itemsList.get(i);
            item.recalcVisible(this);
            ++i;
        }
    }

    public void draw3DLine(Graphics2D graphics2d, Vector vec, Vector vec1) {
        if (vec.isNaN() || vec1.isNaN()) {
            return;
        }
        Vector vec2 = this.project(vec);
        Vector vec3 = this.project(vec1);
        if (vec2.z < 0.01 && vec3.z < 0.01) {
            return;
        }
        if (vec2.z < 0.01) {
            Vector vec4 = vec;
            vec = vec1;
            vec1 = vec4;
            vec4 = vec2;
            vec2 = vec3;
            vec3 = vec4;
        }
        if (vec3.z < 0.01) {
            vec1 = vec.scalarMult(0.01 - vec3.z).add(vec1.scalarMult(vec2.z - 0.01)).scalarDivide(vec2.z - vec3.z);
            vec3 = this.project(vec1);
        }
        graphics2d.drawLine((int)vec2.x, -((int)vec2.y), (int)vec3.x, -((int)vec3.y));
    }

    private void paintAsSolid(Graphics2D graphics2d) {
        LinkedList<SgGraphItemPart> linkedlist = new LinkedList<SgGraphItemPart>();
        this.axesDefinition.addAxesItems(linkedlist);
        int i = 0;
        while (i < this.itemsList.size()) {
            SgGraphItem<K, L> item = this.itemsList.get(i);
            item.addVisibleElementsToList(this, linkedlist);
            ++i;
        }
        Collections.sort(linkedlist);
        for (SgGraphItemPart element : linkedlist) {
            element.render(graphics2d);
        }
    }

    private void paintAsWireframe(Graphics2D graphics2d) {
        this.axesDefinition.paintAsWireframe(this, graphics2d);
        int j = 0;
        while (j < this.itemsList.size()) {
            SgGraphItem<K, L> item = this.itemsList.get(j);
            item.paintAsWireframe(this, graphics2d);
            ++j;
        }
    }

    public void paintToGrphics(Graphics g, int i, int j) {
        Graphics2D graphics2d = (Graphics2D)g.create();
        if (!this.backCulling) {
            graphics2d.setColor(Color.WHITE);
        } else {
            graphics2d.setColor(this.bgColor);
        }
        graphics2d.fillRect(0, 0, i, j);
        graphics2d.translate(i / 2, j / 2);
        if (this.backCulling) {
            this.paintAsSolid(graphics2d);
        } else {
            this.paintAsWireframe(graphics2d);
        }
        if (!this.title.equals("")) {
            Graphics2D graphics2d1 = (Graphics2D)g.create();
            graphics2d1.setFont(graphics2d1.getFont().deriveFont(this.backCulling ? 1 : 0, 12.0f));
            Rectangle2D r2d = graphics2d1.getFontMetrics().getStringBounds(this.title, graphics2d1);
            int w = (int)r2d.getWidth();
            int h = (int)r2d.getHeight();
            Rectangle r = new Rectangle(i / 2 - w / 2, j - h - 10, w, h);
            if (this.backCulling) {
                graphics2d1.setColor(new Color(0, 0, 0, 32));
                graphics2d1.fillRect(0, r.y + 3, i, r.height + 2);
                graphics2d1.setColor(new Color(255, 255, 255, 128));
                graphics2d1.drawString(this.title, r.x, r.y + r.height);
            }
            graphics2d1.setColor(new Color(0, 0, 0, 128));
            graphics2d1.drawString(this.title, r.x + 1, r.y + r.height + 1);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Dimension dimension = this.getSize();
        this.paintToGrphics(g, dimension.width, dimension.height);
    }

    public void saveImage(String s) throws IOException {
        BufferedImage bufferedimage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics g = bufferedimage.getGraphics();
        int i = bufferedimage.getWidth();
        int j = bufferedimage.getHeight();
        this.paintToGrphics(bufferedimage.getGraphics(), bufferedimage.getWidth(), bufferedimage.getHeight());
        Color color = !this.backCulling ? Color.WHITE : this.bgColor;
        g.setColor(Utils.blendColors(Color.BLACK, color, 0.5));
        g.drawRect(1, 1, i - 3, j - 3);
        g.setColor(Utils.blendColors(Color.WHITE, color, 0.5));
        g.drawRect(0, 0, i - 1, j - 1);
        ImageIO.write((RenderedImage)bufferedimage, "png", new File(s));
    }

    JFrame getFrame() {
        Container the = this;
        while ((the = the.getParent()) != null && !(the instanceof JFrame)) {
        }
        return (JFrame)the;
    }

    private void setTitle() {
        JFrame frame = this.getFrame();
        if (frame != null) {
            frame.setTitle("Science Graph - v1.0");
        }
    }

    public void SaveAsImage() {
        String s = this.getFileName(true, ".png");
        if (s == null) {
            return;
        }
        try {
            this.saveImage(s);
        }
        catch (IOException ioexception) {
            JOptionPane.showMessageDialog(this, "Could not export to file " + s, "Warning", 2);
        }
    }

    private String getFileName(boolean save, String s) {
        JFileChooser jfilechooser = new JFileChooser();
        jfilechooser.setCurrentDirectory(new File(this.lastDirectory != null ? this.lastDirectory : System.getProperty("user.dir")));
        int i = save ? jfilechooser.showSaveDialog(this) : jfilechooser.showOpenDialog(this);
        if (i == 0) {
            String s1;
            this.lastDirectory = s1 = jfilechooser.getSelectedFile().getPath();
            this.lastDirectory = this.lastDirectory.substring(0, this.lastDirectory.lastIndexOf(File.separatorChar));
            if (save && s1.indexOf(46) == -1) {
                s1 = String.valueOf(s1) + s;
            }
            if (save && new File(s1).exists() && JOptionPane.showConfirmDialog(this, "File " + s1 + " already exists. Overwrite?", "Warning", 0, 2) == 1) {
                return null;
            }
            return s1;
        }
        return null;
    }

    public void runApplication() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame jframe = new JFrame();
        jframe.getContentPane().add(this);
        jframe.setSize(640, 480);
        jframe.setLocationRelativeTo(null);
        jframe.setIconImage(Utils.loadIcon("sciGraph.gif"));
        jframe.setDefaultCloseOperation(0);
        jframe.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowevent) {
                System.exit(0);
            }
        });
        this.setTitle();
        jframe.setVisible(true);
    }

    public void generateTestCase(String fname, String dataType) throws FileNotFoundException {
        PrintWriter p = new PrintWriter(String.valueOf(fname) + ".java");
        p.println("");
        p.println("import NCTR.graph.SciGraph.*;");
        p.println("");
        p.println("public class " + fname + "  { ");
        p.println("");
        p.println("// -------------------------------------------------------------------");
        p.println("public static void main(String args[])");
        p.println("{");
        p.println("");
        p.println("        SciGraph" + dataType + " sg = new SciGraph" + dataType + "(); ");
        p.println("        sg.runApplication();            \t");
        int i = 0;
        while (i < this.itemsList.size()) {
            SgGraphItem<K, L> item = this.itemsList.get(i);
            String constructor = item.generateTestCase(dataType);
            p.println("        sg.add( " + constructor + " );");
            ++i;
        }
        p.println("        sg.autoScaleData();    ");
        p.println("        sg.resetView(" + this.eyePosition.x + ", " + this.eyePosition.y + ", " + this.eyePosition.z + ");");
        p.println("        sg.repaint();          ");
        p.println("} ");
        p.println("} ");
        p.println("");
        p.close();
    }

    public static void main(String[] args) {
        SciGraph sg = new SciGraph();
        sg.runApplication();
        sg.add(new SgSphere(-0.17, 0.17, 0.25, new Color(204, 255, 204, 255)));
        sg.add(new SgSphere(0.2, 0.2, 0.25, Color.red));
        sg.add(new SgSphere(0.27, 0.17, 0.36, new Color(102, 102, 255, 255)));
        sg.add(new SgSphere(0.47, 0.21, 0.16, new Color(0, 204, 0, 255)));
        sg.add(new SgSphere(0.21, 0.42, 0.16, new Color(42, 20, 243, 255)));
        sg.add(new SgSphere(0.5, 0.5, 0.3, new Color(42, 20, 243, 255)));
        sg.add(new SgGrid(0));
        sg.add(new SgGrid(1));
        sg.add(new SgGrid(2));
        sg.repaint();
    }

    private static class KeyBoard {
        private double targetForward = 0.0;
        private Point2D.Double targetTranslate = new Point2D.Double(0.0, 0.0);
        private Point2D.Double targetRotate = new Point2D.Double(0.0, 0.0);
        private double targetBank = 0.0;
        private Point2D.Double targetPivotRotate = new Point2D.Double(0.0, 0.0);
        private double velForward = 0.0;
        private Point2D.Double velTranslate = new Point2D.Double(0.0, 0.0);
        private Point2D.Double velRotate = new Point2D.Double(0.0, 0.0);
        private double velBank = 0.0;
        private Point2D.Double velPivotRotate = new Point2D.Double(0.0, 0.0);

        private KeyBoard() {
        }
    }

    private class OnKey
    extends KeyAdapter {
        @Override
        public void keyReleased(KeyEvent keyevent) {
            SciGraph.this.keyBoard.targetBank = 0.0;
            SciGraph.this.keyBoard.targetForward = 0.0;
        }

        @Override
        public void keyPressed(KeyEvent keyevent) {
            boolean flag = true;
            switch (keyevent.getKeyCode()) {
                case 84: {
                    try {
                        SciGraph.this.generateTestCase("SciGraphTestCase100", "<Integer, String>");
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace(System.out);
                    }
                    break;
                }
                case 63: {
                    SciGraph.this.showEyeView();
                    break;
                }
                case 90: {
                    SciGraph.this.keyBoard.targetForward = 7.0;
                    break;
                }
                case 88: {
                    SciGraph.this.keyBoard.targetForward = -7.0;
                    break;
                }
                case 44: 
                case 60: {
                    SciGraph.this.keyBoard.targetBank = 0.15;
                    break;
                }
                case 46: 
                case 62: {
                    SciGraph.this.keyBoard.targetBank = -0.15;
                    break;
                }
                case 27: 
                case 32: {
                    SciGraph.this.resetView();
                    break;
                }
                default: {
                    flag = false;
                }
            }
            if (flag) {
                SciGraph.this.timer.start();
            }
        }

        private OnKey() {
        }
    }

    private class OnMouse
    extends MouseInputAdapter {
        private Point lastPoint = new Point(0, 0);

        @Override
        public void mousePressed(MouseEvent mouseevent) {
            this.lastPoint = new Point(mouseevent.getX(), mouseevent.getY());
            SciGraph.this.requestFocusInWindow();
        }

        @Override
        public void mouseDragged(MouseEvent mouseevent) {
            Point point = new Point(mouseevent.getX(), mouseevent.getY());
            double dx = (float)(point.x - this.lastPoint.x) / 100.0f;
            double dy = (float)(point.y - this.lastPoint.y) / 100.0f;
            if (mouseevent.isShiftDown()) {
                Rectangle rectangle = SciGraph.this.getBounds();
                double rx = point.x - (rectangle.x + rectangle.width / 2);
                double ry = point.y - (rectangle.y + rectangle.height / 2);
                double dr = Math.sqrt(rx * rx + ry * ry);
                SciGraph.this.cameraBank((dx * ry - dy * rx) / dr);
            } else if (mouseevent.isAltDown()) {
                SciGraph.this.cameraForward(dy);
            } else {
                SciGraph.this.cameraRotate(-dx, -dy, true);
            }
            this.lastPoint = point;
        }

        private OnMouse() {
        }
    }

    private class TimerListener
    implements ActionListener {
        private long lastTime = 0L;

        @Override
        public void actionPerformed(ActionEvent actionevent) {
            long l = System.currentTimeMillis();
            long l1 = l - this.lastTime;
            if (l1 <= 0L || l1 > (long)(2 * SciGraph.this.timer.getDelay())) {
                l1 = SciGraph.this.timer.getDelay();
            }
            double d = (double)l1 / 100.0;
            this.lastTime = l;
            boolean flag = true;
            double d1 = Math.pow(0.2, d);
            SciGraph.this.keyBoard.velForward = SciGraph.this.keyBoard.velForward * d1 + SciGraph.this.keyBoard.targetForward * d * (1.0 - d1);
            if (Math.abs(SciGraph.this.keyBoard.velForward) > 0.001) {
                flag = false;
                SciGraph.this.cameraForward(SciGraph.this.keyBoard.velForward);
            }
            ((KeyBoard)((SciGraph)SciGraph.this).keyBoard).velTranslate.x = ((KeyBoard)((SciGraph)SciGraph.this).keyBoard).velTranslate.x * d1 + ((KeyBoard)((SciGraph)SciGraph.this).keyBoard).targetTranslate.x * d * (1.0 - d1);
            ((KeyBoard)((SciGraph)SciGraph.this).keyBoard).velTranslate.y = ((KeyBoard)((SciGraph)SciGraph.this).keyBoard).velTranslate.y * d1 + ((KeyBoard)((SciGraph)SciGraph.this).keyBoard).targetTranslate.y * d * (1.0 - d1);
            if (Math.abs(((KeyBoard)((SciGraph)SciGraph.this).keyBoard).velTranslate.x) > 0.001 || Math.abs(((KeyBoard)((SciGraph)SciGraph.this).keyBoard).velTranslate.y) > 0.001) {
                flag = false;
                SciGraph.this.cameraTranslate(((KeyBoard)((SciGraph)SciGraph.this).keyBoard).velTranslate.x, ((KeyBoard)((SciGraph)SciGraph.this).keyBoard).velTranslate.y);
            }
            ((KeyBoard)((SciGraph)SciGraph.this).keyBoard).velRotate.x = ((KeyBoard)((SciGraph)SciGraph.this).keyBoard).velRotate.x * d1 + ((KeyBoard)((SciGraph)SciGraph.this).keyBoard).targetRotate.x * d * (1.0 - d1);
            ((KeyBoard)((SciGraph)SciGraph.this).keyBoard).velRotate.y = ((KeyBoard)((SciGraph)SciGraph.this).keyBoard).velRotate.y * d1 + ((KeyBoard)((SciGraph)SciGraph.this).keyBoard).targetRotate.y * d * (1.0 - d1);
            if (Math.abs(((KeyBoard)((SciGraph)SciGraph.this).keyBoard).velRotate.x) > 0.001 || Math.abs(((KeyBoard)((SciGraph)SciGraph.this).keyBoard).velRotate.y) > 0.001) {
                flag = false;
                SciGraph.this.cameraRotate(((KeyBoard)((SciGraph)SciGraph.this).keyBoard).velRotate.x, ((KeyBoard)((SciGraph)SciGraph.this).keyBoard).velRotate.y, false);
            }
            SciGraph.this.keyBoard.velBank = SciGraph.this.keyBoard.velBank * d1 + SciGraph.this.keyBoard.targetBank * d * (1.0 - d1);
            if (Math.abs(SciGraph.this.keyBoard.velBank) > 0.001) {
                flag = false;
                SciGraph.this.cameraBank(SciGraph.this.keyBoard.velBank);
            }
            ((KeyBoard)((SciGraph)SciGraph.this).keyBoard).velPivotRotate.x = ((KeyBoard)((SciGraph)SciGraph.this).keyBoard).velPivotRotate.x * d1 + ((KeyBoard)((SciGraph)SciGraph.this).keyBoard).targetPivotRotate.x * d * (1.0 - d1);
            ((KeyBoard)((SciGraph)SciGraph.this).keyBoard).velPivotRotate.y = ((KeyBoard)((SciGraph)SciGraph.this).keyBoard).velPivotRotate.y * d1 + ((KeyBoard)((SciGraph)SciGraph.this).keyBoard).targetPivotRotate.y * d * (1.0 - d1);
            if (Math.abs(((KeyBoard)((SciGraph)SciGraph.this).keyBoard).velPivotRotate.x) > 0.001 || Math.abs(((KeyBoard)((SciGraph)SciGraph.this).keyBoard).velPivotRotate.y) > 0.001) {
                flag = false;
                SciGraph.this.cameraRotate(((KeyBoard)((SciGraph)SciGraph.this).keyBoard).velPivotRotate.x, ((KeyBoard)((SciGraph)SciGraph.this).keyBoard).velPivotRotate.y, true);
            }
            if (flag) {
                SciGraph.this.timer.stop();
            } else {
                SciGraph.this.timer.restart();
            }
        }

        private TimerListener() {
        }
    }
}

