/*
 * Decompiled with CFR 0.152.
 */
package NCTR.graph.SciGraph;

import java.awt.Color;

public class ColorRGB {
    public int Red;
    public int Green;
    public int Blue;
    public int Alpha;
    private int blendedRed;
    private int blendedGreen;
    private int blendedBlue;
    public static final ColorRGB WHITE = new ColorRGB(Color.WHITE);
    public static final ColorRGB BLACK = new ColorRGB(Color.BLACK);

    public ColorRGB(Color c) {
        if (c != null) {
            this.Red = c.getRed();
            this.Green = c.getGreen();
            this.Blue = c.getBlue();
            this.Alpha = c.getAlpha();
        } else {
            this.Red = 128;
            this.Green = 128;
            this.Blue = 128;
            this.Alpha = 255;
        }
        this.clearBlend();
    }

    public ColorRGB(ColorRGB c) {
        if (c != null) {
            this.Red = c.Red;
            this.Green = c.Green;
            this.Blue = c.Blue;
            this.Alpha = c.Alpha;
        } else {
            this.Red = 128;
            this.Green = 128;
            this.Blue = 128;
            this.Alpha = 255;
        }
        this.clearBlend();
    }

    public ColorRGB(int r, int g, int b, int a) {
        this.Red = r;
        this.Green = g;
        this.Blue = b;
        this.Alpha = a;
        this.clearBlend();
    }

    public void clearBlend() {
        this.blendedRed = this.Red;
        this.blendedGreen = this.Green;
        this.blendedBlue = this.Blue;
    }

    public String toString() {
        return "{" + this.blendedRed + ", " + this.blendedGreen + ", " + this.blendedBlue + "}";
    }

    public Color getColor() {
        return new Color(this.blendedRed, this.blendedGreen, this.blendedBlue, this.Alpha);
    }

    public static Color oldSlowBlendColors(Color color, Color color1, double d) {
        if (color == null || color1 == null) {
            return null;
        }
        double h = 1.0 - d;
        int r = (int)((double)color1.getRed() * d + (double)color.getRed() * h);
        int g = (int)((double)color1.getGreen() * d + (double)color.getGreen() * h);
        int b = (int)((double)color1.getBlue() * d + (double)color.getBlue() * h);
        return new Color(r, g, b, color.getAlpha());
    }

    public void blend(ColorRGB color, double d) {
        if (color != null) {
            double h = 1.0 - d;
            this.blendedRed = (int)((double)color.Red * d + (double)this.Red * h);
            this.blendedGreen = (int)((double)color.Green * d + (double)this.Green * h);
            this.blendedBlue = (int)((double)color.Blue * d + (double)this.Blue * h);
        }
    }

    public void continueBlend(ColorRGB color, double d) {
        if (color != null) {
            double h = 1.0 - d;
            this.blendedRed = (int)((double)color.Red * d + (double)this.blendedRed * h);
            this.blendedGreen = (int)((double)color.Green * d + (double)this.blendedGreen * h);
            this.blendedBlue = (int)((double)color.Blue * d + (double)this.blendedBlue * h);
        }
    }

    public static void main(String[] args) {
        int reps = 100000;
        ColorRGB rgb = new ColorRGB(Color.yellow);
        ColorRGB white = new ColorRGB(Color.white);
        System.out.println("Test 1");
        long start = System.currentTimeMillis();
        Color c = Color.cyan;
        int i = 0;
        while (i < reps) {
            c = ColorRGB.oldSlowBlendColors(Color.yellow, Color.white, 0.7);
            ++i;
        }
        System.out.println("Test color: " + c);
        long end = System.currentTimeMillis();
        double time1 = (double)(end - start) / 1000.0;
        System.out.println("Elapse time: " + time1);
        System.out.println("Test 2");
        start = System.currentTimeMillis();
        i = 0;
        while (i < reps) {
            rgb.blend(white, 0.7);
            ++i;
        }
        System.out.println("Test color: " + rgb.getColor());
        end = System.currentTimeMillis();
        double time2 = (double)(end - start) / 1000.0;
        System.out.println("Elapse time: " + time2);
        System.out.println("Performance: " + time1 / time2 * 100.0 + "% faster.");
    }
}

